<?php
// Trainings endpoints

// Authentication gerekli
$payload = authenticate();
$parent_id = $payload['parent_id']; // parents.id
$user_id = $payload['user_id']; // users.id

// NOT: Admin panel athletes.parent_id'ye users.id yazıyor

// RESTful yapı: action path'ten alınıyor (/api/v1/trainings/list)
// Eğer path'te action yoksa, GET parametresinden al (geriye dönük uyumluluk)
$action = $action ?? $_GET['action'] ?? '';

switch ($request_method) {
    case 'GET':
        // GET için varsayılan action list
        if (empty($action)) {
            $action = 'list';
        }
        
        switch ($action) {
            case 'list':
                // Trainings tablosu var mı kontrol et
                try {
                    $test_stmt = $pdo->query("SHOW TABLES LIKE 'trainings'");
                    if ($test_stmt->rowCount() === 0) {
                        api_response([], 200, 'Antrenman kaydı bulunamadı (trainings tablosu mevcut değil)');
                        break;
                    }
                } catch (PDOException $e) {
                    api_response([], 200, 'Antrenman kaydı bulunamadı');
                    break;
                }
                
                    // Parent'ın user_id'sini al (parents tablosundan)
                    $stmt = $pdo->prepare("SELECT user_id FROM parents WHERE id = ?");
                    $stmt->execute([$parent_id]);
                    $parent_record = $stmt->fetch();
                    
                    if ($parent_record) {
                        $user_id = $parent_record['user_id'];
                    } else {
                        // Eski sistem uyumluluğu: parent_id direkt user_id olabilir
                        $user_id = $parent_id;
                    }
                    
                    // Parent'ın sporcularının antrenman programlarını listele
                    // NOT: Admin panel athletes.parent_id'ye users.id yazıyor
                    $athlete_id = $_GET['athlete_id'] ?? '';
                    $date_from = $_GET['date_from'] ?? '';
                    $date_to = $_GET['date_to'] ?? '';
                    $status = $_GET['status'] ?? '';
                    
                    $where_conditions = ["a.parent_id = ?"];
                    $params = [$user_id]; // user_id kullanıyoruz
                
                if ($athlete_id) {
                    $where_conditions[] = "t.athlete_id = ?";
                    $params[] = $athlete_id;
                }
                
                if ($date_from) {
                    $where_conditions[] = "t.training_date >= ?";
                    $params[] = $date_from;
                }
                
                if ($date_to) {
                    $where_conditions[] = "t.training_date <= ?";
                    $params[] = $date_to;
                }
                
                if ($status) {
                    $where_conditions[] = "t.status = ?";
                    $params[] = $status;
                }
                
                $stmt = $pdo->prepare("
                    SELECT 
                        t.id,
                        t.training_date,
                        t.training_time,
                        t.location,
                        t.notes,
                        t.status,
                        t.created_at,
                        t.updated_at,
                        a.first_name,
                        a.last_name,
                        a.id as athlete_id
                    FROM trainings t
                    JOIN athletes a ON t.athlete_id = a.id
                    WHERE " . implode(' AND ', $where_conditions) . "
                    ORDER BY t.training_date DESC, t.training_time DESC
                ");
                $stmt->execute($params);
                $trainings = $stmt->fetchAll();
                
                // Her antrenman için ek bilgiler
                foreach ($trainings as &$training) {
                    $training['athlete_name'] = $training['first_name'] . ' ' . $training['last_name'];
                    $training['formatted_date'] = date('d.m.Y', strtotime($training['training_date']));
                    $training['formatted_time'] = date('H:i', strtotime($training['training_time']));
                    $training['formatted_datetime'] = date('d.m.Y H:i', strtotime($training['training_date'] . ' ' . $training['training_time']));
                    $training['status_text'] = $training['status'] === 'scheduled' ? 'Planlandı' : 
                                             ($training['status'] === 'completed' ? 'Tamamlandı' : 'İptal Edildi');
                    
                    // Geçmiş mi kontrolü
                    $training['is_past'] = strtotime($training['training_date'] . ' ' . $training['training_time']) < time();
                    $training['is_today'] = date('Y-m-d', strtotime($training['training_date'])) === date('Y-m-d');
                }
                
                api_response($trainings, 200, 'Antrenman programları başarıyla getirildi');
                break;
                
            case 'schedule':
                // Trainings tablosu var mı kontrol et
                try {
                    $test_stmt = $pdo->query("SHOW TABLES LIKE 'trainings'");
                    if ($test_stmt->rowCount() === 0) {
                        api_response([], 200, 'Antrenman kaydı bulunamadı (trainings tablosu mevcut değil)');
                        break;
                    }
                } catch (PDOException $e) {
                    api_response([], 200, 'Antrenman kaydı bulunamadı');
                    break;
                }
                
                // Haftalık antrenman programı
                $week_start = $_GET['week_start'] ?? date('Y-m-d', strtotime('monday this week'));
                $week_end = date('Y-m-d', strtotime($week_start . ' +6 days'));
                
                    // Parent'ın user_id'sini al (parents tablosundan)
                    $stmt = $pdo->prepare("SELECT user_id FROM parents WHERE id = ?");
                    $stmt->execute([$parent_id]);
                    $parent_record = $stmt->fetch();
                    
                    if ($parent_record) {
                        $user_id = $parent_record['user_id'];
                    } else {
                        // Eski sistem uyumluluğu: parent_id direkt user_id olabilir
                        $user_id = $parent_id;
                    }
                    
                    $stmt = $pdo->prepare("
                        SELECT 
                            t.id,
                            t.training_date,
                            t.training_time,
                            t.location,
                            t.notes,
                            t.status,
                            a.first_name,
                            a.last_name,
                            a.id as athlete_id
                        FROM trainings t
                        JOIN athletes a ON t.athlete_id = a.id
                        WHERE (a.parent_id = ? OR (a.parent_id = ? AND ? IS NOT NULL))
                        AND t.training_date BETWEEN ? AND ?
                        ORDER BY t.training_date, t.training_time
                    ");
                    $stmt->execute([$parent_id, $user_id, $user_id, $week_start, $week_end]);
                $trainings = $stmt->fetchAll();
                
                // Günlere göre grupla
                $schedule = [];
                for ($i = 0; $i < 7; $i++) {
                    $date = date('Y-m-d', strtotime($week_start . " +$i days"));
                    $day_name = date('l', strtotime($date));
                    $schedule[$date] = [
                        'date' => $date,
                        'day_name' => $day_name,
                        'formatted_date' => date('d.m.Y', strtotime($date)),
                        'trainings' => []
                    ];
                }
                
                foreach ($trainings as $training) {
                    $date = $training['training_date'];
                    $training['athlete_name'] = $training['first_name'] . ' ' . $training['last_name'];
                    $training['formatted_time'] = date('H:i', strtotime($training['training_time']));
                    $training['status_text'] = $training['status'] === 'scheduled' ? 'Planlandı' : 
                                             ($training['status'] === 'completed' ? 'Tamamlandı' : 'İptal Edildi');
                    $schedule[$date]['trainings'][] = $training;
                }
                
                api_response(array_values($schedule), 200, 'Haftalık antrenman programı başarıyla getirildi');
                break;
                
            case 'upcoming':
                // Trainings tablosu var mı kontrol et
                try {
                    $test_stmt = $pdo->query("SHOW TABLES LIKE 'trainings'");
                    if ($test_stmt->rowCount() === 0) {
                        api_response([], 200, 'Antrenman kaydı bulunamadı (trainings tablosu mevcut değil)');
                        break;
                    }
                } catch (PDOException $e) {
                    api_response([], 200, 'Antrenman kaydı bulunamadı');
                    break;
                }
                
                    // Parent'ın user_id'sini al (parents tablosundan)
                    $stmt = $pdo->prepare("SELECT user_id FROM parents WHERE id = ?");
                    $stmt->execute([$parent_id]);
                    $parent_record = $stmt->fetch();
                    
                    if ($parent_record) {
                        $user_id = $parent_record['user_id'];
                    } else {
                        // Eski sistem uyumluluğu: parent_id direkt user_id olabilir
                        $user_id = $parent_id;
                    }
                    
                    // Yaklaşan antrenmanlar
                    // Hem parents.id hem de users.id (eski sistem) kontrolü yap
                    $limit = $_GET['limit'] ?? 10;
                    
                    $stmt = $pdo->prepare("
                        SELECT 
                            t.id,
                            t.training_date,
                            t.training_time,
                            t.location,
                            t.notes,
                            t.status,
                            a.first_name,
                            a.last_name,
                            a.id as athlete_id
                        FROM trainings t
                        JOIN athletes a ON t.athlete_id = a.id
                        WHERE (a.parent_id = ? OR (a.parent_id = ? AND ? IS NOT NULL))
                        AND t.training_date >= CURDATE()
                        AND t.status = 'scheduled'
                        ORDER BY t.training_date, t.training_time
                        LIMIT ?
                    ");
                    $stmt->bindValue(1, $parent_id, PDO::PARAM_INT);
                    $stmt->bindValue(2, $user_id, PDO::PARAM_INT);
                    $stmt->bindValue(3, $user_id, PDO::PARAM_INT);
                    $stmt->bindValue(4, (int)$limit, PDO::PARAM_INT);
                    $stmt->execute();
                $trainings = $stmt->fetchAll();
                
                foreach ($trainings as &$training) {
                    $training['athlete_name'] = $training['first_name'] . ' ' . $training['last_name'];
                    $training['formatted_date'] = date('d.m.Y', strtotime($training['training_date']));
                    $training['formatted_time'] = date('H:i', strtotime($training['training_time']));
                    $training['formatted_datetime'] = date('d.m.Y H:i', strtotime($training['training_date'] . ' ' . $training['training_time']));
                    
                    // Kaç gün kaldı
                    $days_left = ceil((strtotime($training['training_date']) - time()) / (60 * 60 * 24));
                    $training['days_left'] = $days_left;
                    $training['is_today'] = $days_left === 0;
                    $training['is_tomorrow'] = $days_left === 1;
                }
                
                api_response($trainings, 200, 'Yaklaşan antrenmanlar başarıyla getirildi');
                break;
                
            case 'detail':
                // Belirli bir antrenman detayı
                $training_id = $_GET['id'] ?? '';
                
                if (!$training_id) {
                    api_error('Antrenman ID gerekli', 400);
                }
                
                // NOT: athletes.parent_id hem users.id hem de parents.id olabilir
                $user_id = $payload['user_id'] ?? null;
                
                $stmt = $pdo->prepare("
                    SELECT 
                        t.*,
                        a.first_name,
                        a.last_name,
                        a.id as athlete_id
                    FROM trainings t
                    JOIN athletes a ON t.athlete_id = a.id
                    WHERE t.id = ? AND (a.parent_id = ? OR (a.parent_id = ? AND ? IS NOT NULL))
                ");
                $stmt->execute([$training_id, $parent_id, $user_id, $user_id]);
                $training = $stmt->fetch();
                
                if (!$training) {
                    api_error('Antrenman bulunamadı', 404);
                }
                
                $training['athlete_name'] = $training['first_name'] . ' ' . $training['last_name'];
                $training['formatted_date'] = date('d.m.Y', strtotime($training['training_date']));
                $training['formatted_time'] = date('H:i', strtotime($training['training_time']));
                $training['formatted_datetime'] = date('d.m.Y H:i', strtotime($training['training_date'] . ' ' . $training['training_time']));
                $training['status_text'] = $training['status'] === 'scheduled' ? 'Planlandı' : 
                                         ($training['status'] === 'completed' ? 'Tamamlandı' : 'İptal Edildi');
                
                // Yoklama bilgisi varsa
                $stmt = $pdo->prepare("
                    SELECT status, notes
                    FROM attendance 
                    WHERE athlete_id = ? AND attendance_date = ?
                    LIMIT 1
                ");
                $stmt->execute([$training['athlete_id'], $training['training_date']]);
                $attendance = $stmt->fetch();
                $training['attendance'] = $attendance;
                
                api_response($training, 200, 'Antrenman detayları başarıyla getirildi');
                break;
                
            default:
                api_error('Geçersiz işlem', 400);
        }
        break;
        
    default:
        api_error('Desteklenmeyen HTTP metodu', 405);
}
?>

}
?>
