<?php
// Athletes endpoints

// Authentication gerekli
$payload = authenticate();
$parent_id = $payload['parent_id'];

// RESTful yapı: action path'ten alınıyor (/api/v1/athletes/list)
// Eğer path'te action yoksa, GET parametresinden al (geriye dönük uyumluluk)
$action = $action ?? $_GET['action'] ?? '';

switch ($request_method) {
    case 'GET':
        // GET için varsayılan action list
        if (empty($action)) {
            $action = 'list';
        }
        
        switch ($action) {
            case 'list':
                // Parent'ın user_id'sini al (parents tablosundan)
                $stmt = $pdo->prepare("SELECT user_id FROM parents WHERE id = ?");
                $stmt->execute([$parent_id]);
                $parent_record = $stmt->fetch();
                
                if ($parent_record) {
                    $user_id = $parent_record['user_id'];
                } else {
                    // Eski sistem uyumluluğu: parent_id direkt user_id olabilir
                    $user_id = $parent_id;
                }
                
                // Parent'ın sporcularını listele
                // NOT: Admin panel athletes.parent_id'ye users.id yazıyor
                // Bu yüzden user_id ile sorguluyoruz
                $stmt = $pdo->prepare("
                    SELECT 
                        a.id,
                        a.first_name,
                        a.last_name,
                        a.birth_date,
                        COALESCE(a.gender, '') as gender,
                        a.phone,
                        a.address,
                        a.emergency_contact,
                        COALESCE(a.emergency_phone, '') as emergency_phone,
                        COALESCE(a.medical_notes, '') as medical_notes,
                        a.created_at,
                        a.updated_at,
                        TIMESTAMPDIFF(YEAR, a.birth_date, CURDATE()) as age
                    FROM athletes a
                    WHERE a.parent_id = ?
                    ORDER BY a.first_name, a.last_name
                ");
                $stmt->execute([$user_id]); // user_id kullanıyoruz (users.id)
                $athletes = $stmt->fetchAll();
                
                // Her sporcu için ek bilgileri al
                foreach ($athletes as &$athlete) {
                    // Son antrenman bilgisi
                    $stmt = $pdo->prepare("
                        SELECT t.training_date, t.training_time, t.location
                        FROM trainings t
                        WHERE t.athlete_id = ?
                        ORDER BY t.training_date DESC, t.training_time DESC
                        LIMIT 1
                    ");
                    $stmt->execute([$athlete['id']]);
                    $last_training = $stmt->fetch();
                    $athlete['last_training'] = $last_training;
                    
                    // Son yoklama bilgisi
                    $stmt = $pdo->prepare("
                        SELECT a.status, a.attendance_date
                        FROM attendance a
                        WHERE a.athlete_id = ?
                        ORDER BY a.attendance_date DESC
                        LIMIT 1
                    ");
                    $stmt->execute([$athlete['id']]);
                    $last_attendance = $stmt->fetch();
                    $athlete['last_attendance'] = $last_attendance;
                    
                    // Son ödeme bilgisi
                    $stmt = $pdo->prepare("
                        SELECT p.amount, p.payment_date, p.status
                        FROM payments p
                        WHERE p.athlete_id = ?
                        ORDER BY p.payment_date DESC
                        LIMIT 1
                    ");
                    $stmt->execute([$athlete['id']]);
                    $last_payment = $stmt->fetch();
                    $athlete['last_payment'] = $last_payment;
                }
                
                api_response($athletes, 200, 'Sporcular başarıyla getirildi');
                break;
                
            case 'detail':
                // Belirli bir sporcu detayı
                $athlete_id = $_GET['id'] ?? '';
                
                if (!$athlete_id) {
                    api_error('Sporcu ID gerekli', 400);
                }
                
                $stmt = $pdo->prepare("
                    SELECT 
                        a.*,
                        TIMESTAMPDIFF(YEAR, a.birth_date, CURDATE()) as age
                    FROM athletes a
                    WHERE a.id = ? AND a.parent_id = ?
                ");
                $stmt->execute([$athlete_id, $user_id]); // user_id kullanıyoruz
                $athlete = $stmt->fetch();
                
                if (!$athlete) {
                    api_error('Sporcu bulunamadı', 404);
                }
                
                // Antrenman geçmişi
                $stmt = $pdo->prepare("
                    SELECT 
                        t.training_date,
                        t.training_time,
                        t.location,
                        t.notes
                    FROM trainings t
                    WHERE t.athlete_id = ?
                    ORDER BY t.training_date DESC, t.training_time DESC
                    LIMIT 10
                ");
                $stmt->execute([$athlete_id]);
                $athlete['training_history'] = $stmt->fetchAll();
                
                // Yoklama geçmişi
                $stmt = $pdo->prepare("
                    SELECT 
                        a.attendance_date,
                        a.status,
                        a.notes
                    FROM attendance a
                    WHERE a.athlete_id = ?
                    ORDER BY a.attendance_date DESC
                    LIMIT 10
                ");
                $stmt->execute([$athlete_id]);
                $athlete['attendance_history'] = $stmt->fetchAll();
                
                // Ödeme geçmişi
                $stmt = $pdo->prepare("
                    SELECT 
                        p.amount,
                        p.payment_date,
                        p.status,
                        p.notes
                    FROM payments p
                    WHERE p.athlete_id = ?
                    ORDER BY p.payment_date DESC
                    LIMIT 10
                ");
                $stmt->execute([$athlete_id]);
                $athlete['payment_history'] = $stmt->fetchAll();
                
                api_response($athlete, 200, 'Sporcu detayları başarıyla getirildi');
                break;
                
            case 'stats':
                // Sporcu istatistikleri
                $athlete_id = $_GET['id'] ?? '';
                
                if (!$athlete_id) {
                    api_error('Sporcu ID gerekli', 400);
                }
                
                // Sporcu kontrolü
                $stmt = $pdo->prepare("SELECT id FROM athletes WHERE id = ? AND parent_id = ?");
                $stmt->execute([$athlete_id, $user_id]); // user_id kullanıyoruz
                if (!$stmt->fetch()) {
                    api_error('Sporcu bulunamadı', 404);
                }
                
                // Toplam antrenman sayısı
                $stmt = $pdo->prepare("SELECT COUNT(*) as total FROM trainings WHERE athlete_id = ?");
                $stmt->execute([$athlete_id]);
                $total_trainings = $stmt->fetch()['total'];
                
                // Toplam yoklama sayısı
                $stmt = $pdo->prepare("SELECT COUNT(*) as total FROM attendance WHERE athlete_id = ?");
                $stmt->execute([$athlete_id]);
                $total_attendance = $stmt->fetch()['total'];
                
                // Katılım oranı
                $stmt = $pdo->prepare("
                    SELECT 
                        COUNT(*) as total,
                        SUM(CASE WHEN status = 'present' THEN 1 ELSE 0 END) as present
                    FROM attendance 
                    WHERE athlete_id = ?
                ");
                $stmt->execute([$athlete_id]);
                $attendance_stats = $stmt->fetch();
                $attendance_rate = $attendance_stats['total'] > 0 ? 
                    round(($attendance_stats['present'] / $attendance_stats['total']) * 100, 1) : 0;
                
                // Toplam ödeme
                $stmt = $pdo->prepare("
                    SELECT 
                        SUM(amount) as total_paid,
                        COUNT(*) as total_payments
                    FROM payments 
                    WHERE athlete_id = ? AND status = 'paid'
                ");
                $stmt->execute([$athlete_id]);
                $payment_stats = $stmt->fetch();
                
                // Bekleyen ödeme
                $stmt = $pdo->prepare("
                    SELECT 
                        SUM(amount) as total_pending,
                        COUNT(*) as pending_payments
                    FROM payments 
                    WHERE athlete_id = ? AND status = 'pending'
                ");
                $stmt->execute([$athlete_id]);
                $pending_stats = $stmt->fetch();
                
                $stats = [
                    'total_trainings' => (int)$total_trainings,
                    'total_attendance' => (int)$total_attendance,
                    'attendance_rate' => $attendance_rate,
                    'total_paid' => (float)$payment_stats['total_paid'],
                    'total_payments' => (int)$payment_stats['total_payments'],
                    'total_pending' => (float)$pending_stats['total_pending'],
                    'pending_payments' => (int)$pending_stats['pending_payments']
                ];
                
                api_response($stats, 200, 'Sporcu istatistikleri başarıyla getirildi');
                break;
                
            default:
                api_error('Geçersiz işlem', 400);
        }
        break;
        
    case 'PUT':
        // Sporcu güncelleme (sadece kendi bilgileri)
        $athlete_id = $_GET['id'] ?? '';
        
        if (!$athlete_id) {
            api_error('Sporcu ID gerekli', 400);
        }
        
        $input = json_decode(file_get_contents('php://input'), true);
        
        if (!$input) {
            api_error('Geçersiz veri', 400);
        }
        
        // Sporcu kontrolü
        $stmt = $pdo->prepare("SELECT id FROM athletes WHERE id = ? AND parent_id = ?");
        $stmt->execute([$athlete_id, $parent_id]);
        if (!$stmt->fetch()) {
            api_error('Sporcu bulunamadı', 404);
        }
        
        // Güncellenebilir alanlar
        $allowed_fields = ['phone', 'address', 'emergency_contact', 'emergency_phone', 'medical_notes'];
        $update_fields = [];
        $update_values = [];
        
        foreach ($allowed_fields as $field) {
            if (isset($input[$field])) {
                $update_fields[] = "$field = ?";
                $update_values[] = $input[$field];
            }
        }
        
        if (empty($update_fields)) {
            api_error('Güncellenecek alan bulunamadı', 400);
        }
        
        $update_values[] = $athlete_id;
        
        $stmt = $pdo->prepare("
            UPDATE athletes 
            SET " . implode(', ', $update_fields) . ", updated_at = NOW()
            WHERE id = ?
        ");
        $stmt->execute($update_values);
        
        api_response(null, 200, 'Sporcu bilgileri başarıyla güncellendi');
        break;
        
    default:
        api_error('Desteklenmeyen HTTP metodu', 405);
}
?>
        
        if (empty($update_fields)) {
            api_error('Güncellenecek alan bulunamadı', 400);
        }
        
        $update_values[] = $athlete_id;
        
        $stmt = $pdo->prepare("
            UPDATE athletes 
            SET " . implode(', ', $update_fields) . ", updated_at = NOW()
            WHERE id = ?
        ");
        $stmt->execute($update_values);
        
        api_response(null, 200, 'Sporcu bilgileri başarıyla güncellendi');
        break;
        
    default:
        api_error('Desteklenmeyen HTTP metodu', 405);
}
?>