-- Parents tablosunu oluştur (API için gerekli)

-- Önce user_type enum'ını güncelle (eğer 'parent' yoksa)
-- Not: Eğer enum'da 'parent' zaten varsa bu hata verebilir, önemli değil
ALTER TABLE users MODIFY COLUMN user_type ENUM('admin', 'veli', 'parent') DEFAULT 'veli';

-- last_login kolonunu ekle (eğer yoksa)
-- Not: Eğer kolon zaten varsa bu hata verebilir, önemli değil
SET @dbname = DATABASE();
SET @tablename = 'users';
SET @columnname = 'last_login';
SET @preparedStatement = (SELECT IF(
  (
    SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
    WHERE
      (table_name = @tablename)
      AND (table_schema = @dbname)
      AND (column_name = @columnname)
  ) > 0,
  'SELECT 1',
  CONCAT('ALTER TABLE ', @tablename, ' ADD COLUMN ', @columnname, ' TIMESTAMP NULL')
));
PREPARE alterIfNotExists FROM @preparedStatement;
EXECUTE alterIfNotExists;
DEALLOCATE PREPARE alterIfNotExists;

-- Parents tablosunu oluştur
CREATE TABLE IF NOT EXISTS parents (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL UNIQUE,
    phone VARCHAR(20),
    address TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    INDEX idx_user_id (user_id)
);

-- Mevcut veli kullanıcıları için parents kayıtları oluştur
-- (Sadece user_type = 'veli' veya 'parent' olan kullanıcılar için)
INSERT INTO parents (user_id, phone, address, created_at)
SELECT 
    u.id,
    u.phone,
    '',
    u.created_at
FROM users u
LEFT JOIN parents p ON u.id = p.user_id
WHERE (u.user_type = 'veli' OR u.user_type = 'parent')
  AND p.id IS NULL;

