# BAŞKENT 1910 GÜCÜ SK - REST API

Bu API, BAŞKENT 1910 GÜCÜ SK admin paneli için geliştirilmiş REST API'dir. Android uygulaması ve diğer istemci uygulamaları bu API'yi kullanarak veri alışverişi yapabilir.

## 🔧 Özellikler

- **JWT Token Authentication** - Güvenli kimlik doğrulama
- **CORS Desteği** - Cross-origin istekler için
- **Rate Limiting** - API kötüye kullanımını önleme
- **RESTful Endpoints** - Standart HTTP metodları
- **JSON Response** - Tüm yanıtlar JSON formatında
- **Error Handling** - Kapsamlı hata yönetimi

## 📚 API Endpoints

### Authentication (`/api/v1/auth`)

#### POST `/api/v1/auth/login`
Parent girişi yapar.

**Request:**
```json
{
    "username": "parent_username",
    "password": "parent_password"
}
```

**Response:**
```json
{
    "success": true,
    "message": "Giriş başarılı",
    "data": {
        "token": "jwt_token_here",
        "user": {
            "id": 1,
            "username": "parent_username",
            "full_name": "Parent Name",
            "email": "parent@email.com",
            "phone": "5551234567"
        }
    }
}
```

#### POST `/api/v1/auth/register`
Yeni parent kaydı oluşturur.

**Request:**
```json
{
    "username": "new_parent",
    "password": "password123",
    "full_name": "New Parent",
    "email": "newparent@email.com",
    "phone": "5551234567"
}
```

#### GET `/api/v1/auth/verify`
Token doğrulama.

**Headers:**
```
Authorization: Bearer jwt_token_here
```

### Athletes (`/api/v1/athletes`)

#### GET `/api/v1/athletes/list`
Parent'ın sporcularını listeler.

**Headers:**
```
Authorization: Bearer jwt_token_here
```

**Query Parameters:**
- `athlete_id` (optional): Belirli sporcu ID'si
- `status` (optional): Sporcu durumu
- `date_from` (optional): Başlangıç tarihi
- `date_to` (optional): Bitiş tarihi

#### GET `/api/v1/athletes/detail?id={athlete_id}`
Belirli sporcu detaylarını getirir.

#### GET `/api/v1/athletes/stats?id={athlete_id}`
Sporcu istatistiklerini getirir.

### Payments (`/api/v1/payments`)

#### GET `/api/v1/payments/list`
Ödeme bilgilerini listeler.

**Query Parameters:**
- `athlete_id` (optional): Sporcu ID'si
- `status` (optional): Ödeme durumu (paid, pending, overdue)
- `year` (optional): Yıl
- `month` (optional): Ay

#### GET `/api/v1/payments/summary`
Ödeme özetini getirir.

#### GET `/api/v1/payments/detail?id={payment_id}`
Belirli ödeme detaylarını getirir.

### Trainings (`/api/v1/trainings`)

#### GET `/api/v1/trainings/list`
Antrenman programlarını listeler.

**Query Parameters:**
- `athlete_id` (optional): Sporcu ID'si
- `date_from` (optional): Başlangıç tarihi
- `date_to` (optional): Bitiş tarihi
- `status` (optional): Antrenman durumu

#### GET `/api/v1/trainings/schedule`
Haftalık antrenman programını getirir.

**Query Parameters:**
- `week_start` (optional): Hafta başlangıç tarihi

#### GET `/api/v1/trainings/upcoming`
Yaklaşan antrenmanları getirir.

**Query Parameters:**
- `limit` (optional): Maksimum kayıt sayısı (default: 10)

### Attendance (`/api/v1/attendance`)

#### GET `/api/v1/attendance/list`
Yoklama bilgilerini listeler.

**Query Parameters:**
- `athlete_id` (optional): Sporcu ID'si
- `date_from` (optional): Başlangıç tarihi
- `date_to` (optional): Bitiş tarihi
- `status` (optional): Yoklama durumu (present, absent, excused)

#### GET `/api/v1/attendance/summary`
Yoklama özetini getirir.

#### GET `/api/v1/attendance/calendar`
Takvim görünümünde yoklama verilerini getirir.

### Notifications (`/api/v1/notifications`)

#### GET `/api/v1/notifications/list`
Bildirimleri listeler.

**Query Parameters:**
- `limit` (optional): Maksimum kayıt sayısı (default: 50)
- `offset` (optional): Başlangıç kaydı (default: 0)
- `status` (optional): Bildirim durumu
- `type` (optional): Bildirim türü

#### GET `/api/v1/notifications/unread`
Okunmamış bildirimleri getirir.

#### GET `/api/v1/notifications/count`
Okunmamış bildirim sayısını getirir.

#### PUT `/api/v1/notifications/read?id={notification_id}`
Bildirimi okundu olarak işaretler.

#### PUT `/api/v1/notifications/read_all`
Tüm bildirimleri okundu olarak işaretler.

### Profile (`/api/v1/profile`)

#### GET `/api/v1/profile/info`
Profil bilgilerini getirir.

#### GET `/api/v1/profile/stats`
Profil istatistiklerini getirir.

#### PUT `/api/v1/profile/update`
Profil bilgilerini günceller.

**Request:**
```json
{
    "phone": "5551234567",
    "address": "New Address"
}
```

#### PUT `/api/v1/profile/change_password`
Şifre değiştirir.

**Request:**
```json
{
    "current_password": "old_password",
    "new_password": "new_password"
}
```

## 🔐 Authentication

API, JWT (JSON Web Token) tabanlı kimlik doğrulama kullanır. Tüm korumalı endpoint'ler için `Authorization` header'ında Bearer token gönderilmelidir.

```
Authorization: Bearer your_jwt_token_here
```

## 📊 Response Format

Tüm API yanıtları aşağıdaki formatta döner:

```json
{
    "success": true,
    "message": "İşlem başarılı",
    "timestamp": "2024-01-01 12:00:00",
    "data": {
        // Response data
    }
}
```

## ❌ Error Handling

Hata durumlarında HTTP status kodları ve açıklayıcı mesajlar döner:

```json
{
    "success": false,
    "message": "Hata mesajı",
    "timestamp": "2024-01-01 12:00:00",
    "data": null
}
```

## 🚀 Rate Limiting

API, saatte 100 istek sınırı uygular. Limit aşıldığında 429 status kodu döner.

## 📱 Android Uygulaması İçin

Bu API, Android uygulaması geliştirirken kullanılabilir. Retrofit veya benzeri HTTP kütüphaneleri ile entegre edilebilir.

### Örnek Android Kullanımı:

```java
// Retrofit interface
public interface ApiService {
    @POST("auth/login")
    Call<ApiResponse<LoginResponse>> login(@Body LoginRequest request);
    
    @GET("athletes/list")
    Call<ApiResponse<List<Athlete>>> getAthletes(@Header("Authorization") String token);
}

// Kullanım
ApiService apiService = retrofit.create(ApiService.class);
Call<ApiResponse<LoginResponse>> call = apiService.login(loginRequest);
call.enqueue(new Callback<ApiResponse<LoginResponse>>() {
    @Override
    public void onResponse(Call<ApiResponse<LoginResponse>> call, Response<ApiResponse<LoginResponse>> response) {
        if (response.isSuccessful()) {
            String token = response.body().getData().getToken();
            // Token'ı kaydet ve diğer isteklerde kullan
        }
    }
    
    @Override
    public void onFailure(Call<ApiResponse<LoginResponse>> call, Throwable t) {
        // Hata yönetimi
    }
});
```

## 🔧 Kurulum

1. Veritabanı tablolarını oluşturun (`config/create_tables.sql`)
2. API dosyalarını web sunucunuza yükleyin
3. `config/database.php` dosyasını düzenleyin
4. API'yi test edin

## 📞 Destek

API ile ilgili sorularınız için admin paneli üzerinden iletişime geçebilirsiniz.






