<?php
$page_title = 'Veli Şifre Yönetimi - BAŞKENT 1910 GÜCÜ SK';
require_once __DIR__ . '/../includes/header.php';

$action = $_GET['action'] ?? 'list';
$message = '';
$error = '';

// Şifre sıfırlama işlemi
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $action === 'reset_password') {
    $user_id = $_POST['user_id'] ?? '';
    $new_password = trim($_POST['new_password'] ?? '');
    $confirm_password = trim($_POST['confirm_password'] ?? '');
    $reset_reason = $_POST['reset_reason'] ?? 'admin_reset';
    
    if ($user_id && $new_password && $confirm_password) {
        if ($new_password === $confirm_password) {
            if (strlen($new_password) >= 6) {
                try {
                    // Eski şifreyi geçmişe kaydet
                    $stmt = $pdo->prepare("SELECT password FROM users WHERE id = ?");
                    $stmt->execute([$user_id]);
                    $old_password = $stmt->fetch()['password'];
                    
                    $stmt = $pdo->prepare("INSERT INTO password_history (user_id, old_password, changed_by, change_reason) VALUES (?, ?, ?, ?)");
                    $stmt->execute([$user_id, $old_password, $_SESSION['admin_id'], $reset_reason]);
                    
                    // Yeni şifreyi kaydet
                    $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
                    $stmt = $pdo->prepare("UPDATE users SET password = ?, updated_at = NOW() WHERE id = ? AND user_type = 'veli'");
                    $stmt->execute([$hashed_password, $user_id]);
                    
                    $message = "Veli şifresi başarıyla sıfırlandı!";
                } catch (Exception $e) {
                    $error = "Hata: " . $e->getMessage();
                }
            } else {
                $error = "Şifre en az 6 karakter olmalıdır!";
            }
        } else {
            $error = "Şifreler eşleşmiyor!";
        }
    } else {
        $error = "Lütfen tüm alanları doldurun!";
    }
}

// Toplu şifre sıfırlama
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $action === 'bulk_reset') {
    $user_ids = $_POST['user_ids'] ?? [];
    $new_password = trim($_POST['bulk_password'] ?? '');
    $confirm_password = trim($_POST['bulk_confirm_password'] ?? '');
    
    if (!empty($user_ids) && $new_password && $confirm_password) {
        if ($new_password === $confirm_password) {
            if (strlen($new_password) >= 6) {
                try {
                    $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
                    $success_count = 0;
                    
                    foreach ($user_ids as $user_id) {
                        // Eski şifreyi geçmişe kaydet
                        $stmt = $pdo->prepare("SELECT password FROM users WHERE id = ? AND user_type = 'veli'");
                        $stmt->execute([$user_id]);
                        $old_password = $stmt->fetch()['password'];
                        
                        if ($old_password) {
                            $stmt = $pdo->prepare("INSERT INTO password_history (user_id, old_password, changed_by, change_reason) VALUES (?, ?, ?, 'admin_reset')");
                            $stmt->execute([$user_id, $old_password, $_SESSION['admin_id']]);
                            
                            // Yeni şifreyi kaydet
                            $stmt = $pdo->prepare("UPDATE users SET password = ?, updated_at = NOW() WHERE id = ? AND user_type = 'veli'");
                            $stmt->execute([$hashed_password, $user_id]);
                            $success_count++;
                        }
                    }
                    
                    $message = "Toplu şifre sıfırlama tamamlandı! ($success_count veli güncellendi)";
                } catch (Exception $e) {
                    $error = "Hata: " . $e->getMessage();
                }
            } else {
                $error = "Şifre en az 6 karakter olmalıdır!";
            }
        } else {
            $error = "Şifreler eşleşmiyor!";
        }
    } else {
        $error = "Lütfen veli seçin ve şifre girin!";
    }
}

// Veli listesi
$parents = $pdo->query("
    SELECT u.*, COUNT(a.id) as athlete_count 
    FROM users u 
    LEFT JOIN athletes a ON u.id = a.parent_id 
    WHERE u.user_type = 'veli' 
    GROUP BY u.id 
    ORDER BY u.full_name
")->fetchAll();

// Şifre geçmişi
$password_history = $pdo->query("
    SELECT ph.*, u.full_name as user_name, admin.full_name as changed_by_name
    FROM password_history ph
    JOIN users u ON ph.user_id = u.id
    LEFT JOIN users admin ON ph.changed_by = admin.id
    ORDER BY ph.created_at DESC
    LIMIT 50
")->fetchAll();

// Düzenleme için veli bilgileri
$edit_user = null;
if ($action === 'reset_password' && isset($_GET['id'])) {
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ? AND user_type = 'veli'");
    $stmt->execute([$_GET['id']]);
    $edit_user = $stmt->fetch();
}

// Şifre güvenlik istatistikleri
$security_stats = [];
$stmt = $pdo->query("SELECT COUNT(*) as total FROM users WHERE user_type = 'veli'");
$security_stats['total_users'] = $stmt->fetch()['total'];

$stmt = $pdo->query("SELECT COUNT(*) as total FROM password_history WHERE created_at >= DATE_SUB(NOW(), INTERVAL 30 DAY)");
$security_stats['recent_changes'] = $stmt->fetch()['total'];

$stmt = $pdo->query("SELECT COUNT(*) as total FROM password_history WHERE change_reason = 'admin_reset' AND created_at >= DATE_SUB(NOW(), INTERVAL 7 DAY)");
$security_stats['admin_resets'] = $stmt->fetch()['total'];
?>

<div class="page-header">
    <div class="page-title">
        <i class="fas fa-user-shield"></i>
        <h2>Veli Şifre Yönetimi</h2>
    </div>
    <div class="header-actions">
        <a href="?action=bulk_reset" class="btn btn-warning">
            <i class="fas fa-users"></i>
            <span>Toplu Sıfırlama</span>
        </a>
    </div>
</div>

<?php if ($message): ?>
    <div class="alert alert-success">
        <i class="fas fa-check-circle"></i>
        <?php echo htmlspecialchars($message); ?>
    </div>
<?php endif; ?>

<?php if ($error): ?>
    <div class="alert alert-error">
        <i class="fas fa-exclamation-circle"></i>
        <?php echo htmlspecialchars($error); ?>
    </div>
<?php endif; ?>

<!-- Güvenlik İstatistikleri -->
<div class="security-stats">
    <div class="stats-row">
        <div class="stat-item">
            <div class="stat-icon">
                <i class="fas fa-users"></i>
            </div>
            <div class="stat-content">
                <h4><?php echo $security_stats['total_users']; ?></h4>
                <p>Toplam Veli</p>
            </div>
        </div>
        
        <div class="stat-item">
            <div class="stat-icon">
                <i class="fas fa-key"></i>
            </div>
            <div class="stat-content">
                <h4><?php echo $security_stats['recent_changes']; ?></h4>
                <p>Son 30 Gün Değişim</p>
            </div>
        </div>
        
        <div class="stat-item">
            <div class="stat-icon">
                <i class="fas fa-tools"></i>
            </div>
            <div class="stat-content">
                <h4><?php echo $security_stats['admin_resets']; ?></h4>
                <p>Son 7 Gün Admin Sıfırlama</p>
            </div>
        </div>
    </div>
</div>

<?php if ($action === 'reset_password'): ?>
    <div class="form-container">
        <h3>
            <i class="fas fa-key"></i>
            Şifre Sıfırla
        </h3>
        
        <form method="post" action="">
            <input type="hidden" name="user_id" value="<?php echo $edit_user['id']; ?>">
            
            <div class="user-info">
                <div class="user-avatar">
                    <i class="fas fa-user"></i>
                </div>
                <div class="user-details">
                    <h4><?php echo htmlspecialchars($edit_user['full_name']); ?></h4>
                    <p><?php echo htmlspecialchars($edit_user['username']); ?> • <?php echo htmlspecialchars($edit_user['email']); ?></p>
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-group">
                    <label>Yeni Şifre *</label>
                    <input type="password" name="new_password" required minlength="6" placeholder="En az 6 karakter">
                    <small class="form-help">En az 6 karakter olmalıdır</small>
                </div>
                <div class="form-group">
                    <label>Şifre Tekrar *</label>
                    <input type="password" name="confirm_password" required minlength="6" placeholder="Şifreyi tekrar girin">
                </div>
            </div>
            
            <div class="form-group">
                <label>Sıfırlama Nedeni</label>
                <select name="reset_reason">
                    <option value="admin_reset">Admin Sıfırlama</option>
                    <option value="security_reset">Güvenlik Sıfırlama</option>
                </select>
            </div>
            
            <div class="form-actions">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i>
                    <span>Şifreyi Sıfırla</span>
                </button>
                <a href="?" class="btn btn-secondary">
                    <i class="fas fa-times"></i>
                    <span>İptal</span>
                </a>
            </div>
        </form>
    </div>

<?php elseif ($action === 'bulk_reset'): ?>
    <div class="form-container">
        <h3>
            <i class="fas fa-users"></i>
            Toplu Şifre Sıfırlama
        </h3>
        
        <form method="post" action="">
            <div class="form-group">
                <label>Veli Seçimi *</label>
                <div class="checkbox-grid">
                    <?php foreach ($parents as $parent): ?>
                        <label class="checkbox-item">
                            <input type="checkbox" name="user_ids[]" value="<?php echo $parent['id']; ?>">
                            <div class="checkbox-content">
                                <span class="user-name"><?php echo htmlspecialchars($parent['full_name']); ?></span>
                                <span class="user-detail"><?php echo htmlspecialchars($parent['username']); ?> • <?php echo $parent['athlete_count']; ?> sporcu</span>
                            </div>
                        </label>
                    <?php endforeach; ?>
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-group">
                    <label>Yeni Şifre *</label>
                    <input type="password" name="bulk_password" required minlength="6" placeholder="En az 6 karakter">
                </div>
                <div class="form-group">
                    <label>Şifre Tekrar *</label>
                    <input type="password" name="bulk_confirm_password" required minlength="6" placeholder="Şifreyi tekrar girin">
                </div>
            </div>
            
            <div class="form-actions">
                <button type="submit" class="btn btn-warning">
                    <i class="fas fa-users"></i>
                    <span>Toplu Sıfırlama Yap</span>
                </button>
                <a href="?" class="btn btn-secondary">
                    <i class="fas fa-times"></i>
                    <span>İptal</span>
                </a>
            </div>
        </form>
    </div>

<?php else: ?>
    <!-- Veli Listesi -->
    <div class="table-container">
        <div class="table-header">
            <h3><i class="fas fa-users"></i> Veli Listesi</h3>
            <div class="table-actions">
                <button onclick="selectAll()" class="btn btn-sm btn-secondary">
                    <i class="fas fa-check-square"></i>
                    Tümünü Seç
                </button>
                <button onclick="deselectAll()" class="btn btn-sm btn-secondary">
                    <i class="fas fa-square"></i>
                    Seçimi Kaldır
                </button>
            </div>
        </div>
        
        <table class="data-table">
            <thead>
                <tr>
                    <th width="50">
                        <input type="checkbox" id="selectAll" onchange="toggleAll()">
                    </th>
                    <th>Ad Soyad</th>
                    <th>Kullanıcı Adı</th>
                    <th>Email</th>
                    <th>Sporcu Sayısı</th>
                    <th>Son Güncelleme</th>
                    <th>İşlemler</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($parents as $parent): ?>
                    <tr>
                        <td>
                            <input type="checkbox" class="user-checkbox" value="<?php echo $parent['id']; ?>">
                        </td>
                        <td><?php echo htmlspecialchars($parent['full_name']); ?></td>
                        <td><?php echo htmlspecialchars($parent['username']); ?></td>
                        <td><?php echo htmlspecialchars($parent['email']); ?></td>
                        <td><?php echo $parent['athlete_count']; ?></td>
                        <td><?php echo date('d.m.Y H:i', strtotime($parent['updated_at'])); ?></td>
                        <td>
                            <a href="?action=reset_password&id=<?php echo $parent['id']; ?>" class="btn btn-sm btn-warning">
                                <i class="fas fa-key"></i>
                                <span>Şifre Sıfırla</span>
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    
    <!-- Şifre Geçmişi -->
    <div class="table-container">
        <div class="table-header">
            <h3><i class="fas fa-history"></i> Şifre Değişim Geçmişi</h3>
        </div>
        
        <table class="data-table">
            <thead>
                <tr>
                    <th>Veli</th>
                    <th>Değiştiren</th>
                    <th>Neden</th>
                    <th>Tarih</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($password_history as $history): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($history['user_name']); ?></td>
                        <td><?php echo htmlspecialchars($history['changed_by_name'] ?? 'Sistem'); ?></td>
                        <td>
                            <span class="status status-<?php echo $history['change_reason']; ?>">
                                <?php 
                                $reasons = [
                                    'admin_reset' => 'Admin Sıfırlama',
                                    'user_change' => 'Kullanıcı Değişimi',
                                    'security_reset' => 'Güvenlik Sıfırlama'
                                ];
                                echo $reasons[$history['change_reason']] ?? $history['change_reason'];
                                ?>
                            </span>
                        </td>
                        <td><?php echo date('d.m.Y H:i', strtotime($history['created_at'])); ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
<?php endif; ?>

<script>
function selectAll() {
    const checkboxes = document.querySelectorAll('.user-checkbox');
    checkboxes.forEach(checkbox => checkbox.checked = true);
    document.getElementById('selectAll').checked = true;
}

function deselectAll() {
    const checkboxes = document.querySelectorAll('.user-checkbox');
    checkboxes.forEach(checkbox => checkbox.checked = false);
    document.getElementById('selectAll').checked = false;
}

function toggleAll() {
    const selectAll = document.getElementById('selectAll');
    const checkboxes = document.querySelectorAll('.user-checkbox');
    checkboxes.forEach(checkbox => checkbox.checked = selectAll.checked);
}
</script>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
