<?php
$page_title = 'Antrenman Programları - BAŞKENT 1910 GÜCÜ SK';
require_once __DIR__ . '/../includes/header.php';

$action = $_GET['action'] ?? 'list';
$message = '';
$error = '';

// Antrenman programı ekleme/düzenleme işlemleri
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $athlete_id = $_POST['athlete_id'] ?? '';
    $day_of_week = $_POST['day_of_week'] ?? '';
    $start_time = $_POST['start_time'] ?? '';
    $end_time = $_POST['end_time'] ?? '';
    $location = trim($_POST['location'] ?? '');
    $coach_name = trim($_POST['coach_name'] ?? '');
    $notes = trim($_POST['notes'] ?? '');
    
    if ($athlete_id && $day_of_week && $start_time && $end_time) {
        try {
            if ($action === 'add') {
                $stmt = $pdo->prepare("INSERT INTO training_schedules (athlete_id, day_of_week, start_time, end_time, location, coach_name, notes) VALUES (?, ?, ?, ?, ?, ?, ?)");
                $stmt->execute([$athlete_id, $day_of_week, $start_time, $end_time, $location, $coach_name, $notes]);
                $message = "Antrenman programı eklendi!";
            } elseif ($action === 'edit' && isset($_GET['id'])) {
                $stmt = $pdo->prepare("UPDATE training_schedules SET athlete_id=?, day_of_week=?, start_time=?, end_time=?, location=?, coach_name=?, notes=? WHERE id=?");
                $stmt->execute([$athlete_id, $day_of_week, $start_time, $end_time, $location, $coach_name, $notes, $_GET['id']]);
                $message = "Antrenman programı güncellendi!";
            }
        } catch (Exception $e) {
            $error = "Hata: " . $e->getMessage();
        }
    } else {
        $error = "Sporcu, gün, başlangıç ve bitiş saati zorunludur!";
    }
}

// Antrenman programı silme işlemi
if ($action === 'delete' && isset($_GET['id'])) {
    try {
        $stmt = $pdo->prepare("DELETE FROM training_schedules WHERE id = ?");
        $stmt->execute([$_GET['id']]);
        $message = "Antrenman programı silindi!";
    } catch (Exception $e) {
        $error = "Hata: " . $e->getMessage();
    }
}

// Sporcu listesi (dropdown için)
$athletes = $pdo->query("SELECT id, first_name, last_name FROM athletes WHERE status = 'active' ORDER BY first_name, last_name")->fetchAll();

// Antrenman programları listesi
$trainings = $pdo->query("
    SELECT ts.*, a.first_name, a.last_name 
    FROM training_schedules ts 
    JOIN athletes a ON ts.athlete_id = a.id 
    ORDER BY ts.day_of_week, ts.start_time
")->fetchAll();

// Düzenleme için antrenman bilgileri
$edit_training = null;
if ($action === 'edit' && isset($_GET['id'])) {
    $stmt = $pdo->prepare("SELECT * FROM training_schedules WHERE id = ?");
    $stmt->execute([$_GET['id']]);
    $edit_training = $stmt->fetch();
}

// Günler
$days = ['Pazartesi', 'Salı', 'Çarşamba', 'Perşembe', 'Cuma', 'Cumartesi', 'Pazar'];
?>

<div class="page-header">
    <div class="page-title">
        <i class="fas fa-dumbbell"></i>
        <h2>Antrenman Programları</h2>
    </div>
    <a href="?action=add" class="btn btn-primary">
        <i class="fas fa-plus"></i>
        <span>Yeni Program Ekle</span>
    </a>
</div>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>

<?php if ($error): ?>
    <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<?php if ($action === 'add' || $action === 'edit'): ?>
    <div class="form-container">
        <h3>
            <i class="fas fa-<?php echo $action === 'add' ? 'plus' : 'edit'; ?>"></i>
            <?php echo $action === 'add' ? 'Yeni Antrenman Programı' : 'Antrenman Programı Düzenle'; ?>
        </h3>
        
        <form method="post" action="">
            <div class="form-row">
                <div class="form-group">
                    <label>Sporcu *</label>
                    <select name="athlete_id" required>
                        <option value="">Sporcu Seçin</option>
                        <?php foreach ($athletes as $athlete): ?>
                            <option value="<?php echo $athlete['id']; ?>" <?php echo ($edit_training['athlete_id'] ?? '') == $athlete['id'] ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($athlete['first_name'] . ' ' . $athlete['last_name']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label>Gün *</label>
                    <select name="day_of_week" required>
                        <option value="">Gün Seçin</option>
                        <?php foreach ($days as $day): ?>
                            <option value="<?php echo $day; ?>" <?php echo ($edit_training['day_of_week'] ?? '') == $day ? 'selected' : ''; ?>>
                                <?php echo $day; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-group">
                    <label>Başlangıç Saati *</label>
                    <input type="time" name="start_time" value="<?php echo $edit_training['start_time'] ?? ''; ?>" required>
                </div>
                <div class="form-group">
                    <label>Bitiş Saati *</label>
                    <input type="time" name="end_time" value="<?php echo $edit_training['end_time'] ?? ''; ?>" required>
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-group">
                    <label>Lokasyon</label>
                    <input type="text" name="location" value="<?php echo htmlspecialchars($edit_training['location'] ?? ''); ?>">
                </div>
                <div class="form-group">
                    <label>Antrenör</label>
                    <input type="text" name="coach_name" value="<?php echo htmlspecialchars($edit_training['coach_name'] ?? ''); ?>">
                </div>
            </div>
            
            <div class="form-group">
                <label>Notlar</label>
                <textarea name="notes" rows="3"><?php echo htmlspecialchars($edit_training['notes'] ?? ''); ?></textarea>
            </div>
            
            <div class="form-actions">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-<?php echo $action === 'add' ? 'plus' : 'save'; ?>"></i>
                    <span><?php echo $action === 'add' ? 'Ekle' : 'Güncelle'; ?></span>
                </button>
                <a href="?" class="btn btn-secondary">
                    <i class="fas fa-times"></i>
                    <span>İptal</span>
                </a>
            </div>
        </form>
    </div>
<?php else: ?>
    <div class="table-container">
        <table class="data-table">
            <thead>
                <tr>
                    <th>Sporcu</th>
                    <th>Gün</th>
                    <th>Saat</th>
                    <th>Lokasyon</th>
                    <th>Antrenör</th>
                    <th>İşlemler</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($trainings as $training): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($training['first_name'] . ' ' . $training['last_name']); ?></td>
                        <td><?php echo $training['day_of_week']; ?></td>
                        <td><?php echo date('H:i', strtotime($training['start_time'])) . ' - ' . date('H:i', strtotime($training['end_time'])); ?></td>
                        <td><?php echo htmlspecialchars($training['location'] ?? '-'); ?></td>
                        <td><?php echo htmlspecialchars($training['coach_name'] ?? '-'); ?></td>
                        <td>
                            <a href="?action=edit&id=<?php echo $training['id']; ?>" class="btn btn-sm btn-secondary">
                                <i class="fas fa-edit"></i>
                                <span>Düzenle</span>
                            </a>
                            <a href="?action=delete&id=<?php echo $training['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Emin misiniz?')">
                                <i class="fas fa-trash"></i>
                                <span>Sil</span>
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
<?php endif; ?>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>