<?php
$page_title = 'Sistem Ayarları - BAŞKENT 1910 GÜCÜ SK';
require_once __DIR__ . '/../includes/header.php';

$action = $_GET['action'] ?? 'general';
$message = '';
$error = '';

// Ayarları kaydetme
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $setting_type = $_POST['setting_type'] ?? 'general';
    
    try {
        if ($setting_type === 'general') {
            // Genel ayarlar
            $settings = [
                'system_name' => $_POST['system_name'] ?? '',
                'system_version' => $_POST['system_version'] ?? '',
                'system_description' => $_POST['system_description'] ?? '',
                'contact_email' => $_POST['contact_email'] ?? '',
                'contact_phone' => $_POST['contact_phone'] ?? '',
                'address' => $_POST['address'] ?? '',
                'timezone' => $_POST['timezone'] ?? 'Europe/Istanbul',
                'date_format' => $_POST['date_format'] ?? 'd.m.Y',
                'time_format' => $_POST['time_format'] ?? 'H:i',
                'currency' => $_POST['currency'] ?? 'TRY',
                'currency_symbol' => $_POST['currency_symbol'] ?? '₺'
            ];
            
        } elseif ($setting_type === 'email') {
            // Email ayarları
            $settings = [
                'smtp_host' => $_POST['smtp_host'] ?? '',
                'smtp_port' => $_POST['smtp_port'] ?? '587',
                'smtp_username' => $_POST['smtp_username'] ?? '',
                'smtp_password' => $_POST['smtp_password'] ?? '',
                'smtp_encryption' => $_POST['smtp_encryption'] ?? 'tls',
                'from_email' => $_POST['from_email'] ?? '',
                'from_name' => $_POST['from_name'] ?? '',
                'email_enabled' => isset($_POST['email_enabled']) ? '1' : '0'
            ];
            
        } elseif ($setting_type === 'notifications') {
            // Bildirim ayarları
            $settings = [
                'push_notifications_enabled' => isset($_POST['push_notifications_enabled']) ? '1' : '0',
                'email_notifications_enabled' => isset($_POST['email_notifications_enabled']) ? '1' : '0',
                'sms_notifications_enabled' => isset($_POST['sms_notifications_enabled']) ? '1' : '0',
                'notification_sound' => isset($_POST['notification_sound']) ? '1' : '0',
                'notification_vibration' => isset($_POST['notification_vibration']) ? '1' : '0',
                'auto_backup_enabled' => isset($_POST['auto_backup_enabled']) ? '1' : '0',
                'backup_frequency' => $_POST['backup_frequency'] ?? 'daily',
                'backup_retention' => $_POST['backup_retention'] ?? '30'
            ];
            
        } elseif ($setting_type === 'security') {
            // Güvenlik ayarları
            $settings = [
                'session_timeout' => $_POST['session_timeout'] ?? '3600',
                'max_login_attempts' => $_POST['max_login_attempts'] ?? '5',
                'lockout_duration' => $_POST['lockout_duration'] ?? '900',
                'password_min_length' => $_POST['password_min_length'] ?? '8',
                'password_require_special' => isset($_POST['password_require_special']) ? '1' : '0',
                'two_factor_enabled' => isset($_POST['two_factor_enabled']) ? '1' : '0',
                'ip_whitelist' => $_POST['ip_whitelist'] ?? '',
                'maintenance_mode' => isset($_POST['maintenance_mode']) ? '1' : '0'
            ];
            
        } elseif ($setting_type === 'api') {
            // API ayarları
            $settings = [
                'api_enabled' => isset($_POST['api_enabled']) ? '1' : '0',
                'api_rate_limit' => $_POST['api_rate_limit'] ?? '100',
                'api_rate_window' => $_POST['api_rate_window'] ?? '3600',
                'jwt_secret' => $_POST['jwt_secret'] ?? '',
                'jwt_expiry' => $_POST['jwt_expiry'] ?? '86400',
                'cors_enabled' => isset($_POST['cors_enabled']) ? '1' : '0',
                'cors_origins' => $_POST['cors_origins'] ?? '*',
                'api_logging' => isset($_POST['api_logging']) ? '1' : '0'
            ];
        }
        
        // Ayarları veritabanına kaydet
        foreach ($settings as $key => $value) {
            $stmt = $pdo->prepare("
                INSERT INTO system_settings (setting_key, setting_value, description) 
                VALUES (?, ?, ?) 
                ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)
            ");
            $stmt->execute([$key, $value, ucfirst(str_replace('_', ' ', $key))]);
        }
        
        $message = "Ayarlar başarıyla kaydedildi!";
        
    } catch (Exception $e) {
        $error = "Hata: " . $e->getMessage();
    }
}

// Mevcut ayarları al
$current_settings = [];
$stmt = $pdo->query("SELECT setting_key, setting_value FROM system_settings");
while ($row = $stmt->fetch()) {
    $current_settings[$row['setting_key']] = $row['setting_value'];
}

// Varsayılan değerler
$defaults = [
    'system_name' => 'BAŞKENT 1910 GÜCÜ SK',
    'system_version' => '1.0.0',
    'system_description' => 'Spor Kulübü Yönetim Sistemi',
    'contact_email' => 'info@baskent1910guksk.com',
    'contact_phone' => '+90 312 123 45 67',
    'address' => 'Ankara, Türkiye',
    'timezone' => 'Europe/Istanbul',
    'date_format' => 'd.m.Y',
    'time_format' => 'H:i',
    'currency' => 'TRY',
    'currency_symbol' => '₺',
    'smtp_host' => '',
    'smtp_port' => '587',
    'smtp_username' => '',
    'smtp_password' => '',
    'smtp_encryption' => 'tls',
    'from_email' => '',
    'from_name' => '',
    'email_enabled' => '0',
    'push_notifications_enabled' => '1',
    'email_notifications_enabled' => '1',
    'sms_notifications_enabled' => '0',
    'notification_sound' => '1',
    'notification_vibration' => '1',
    'auto_backup_enabled' => '0',
    'backup_frequency' => 'daily',
    'backup_retention' => '30',
    'session_timeout' => '3600',
    'max_login_attempts' => '5',
    'lockout_duration' => '900',
    'password_min_length' => '8',
    'password_require_special' => '0',
    'two_factor_enabled' => '0',
    'ip_whitelist' => '',
    'maintenance_mode' => '0',
    'api_enabled' => '1',
    'api_rate_limit' => '100',
    'api_rate_window' => '3600',
    'jwt_secret' => '',
    'jwt_expiry' => '86400',
    'cors_enabled' => '1',
    'cors_origins' => '*',
    'api_logging' => '1'
];

// Mevcut ayarları varsayılanlarla birleştir
$settings = array_merge($defaults, $current_settings);

// Sistem bilgileri
$system_info = [
    'php_version' => PHP_VERSION,
    'server_software' => $_SERVER['SERVER_SOFTWARE'] ?? 'Unknown',
    'database_version' => $pdo->query("SELECT VERSION()")->fetchColumn(),
    'disk_space' => [
        'total' => disk_total_space(__DIR__),
        'free' => disk_free_space(__DIR__),
        'used' => disk_total_space(__DIR__) - disk_free_space(__DIR__)
    ],
    'memory_limit' => ini_get('memory_limit'),
    'max_execution_time' => ini_get('max_execution_time'),
    'upload_max_filesize' => ini_get('upload_max_filesize'),
    'post_max_size' => ini_get('post_max_size')
];
?>

<div class="page-header">
    <div class="page-title">
        <i class="fas fa-cogs"></i>
        <h2>Sistem Ayarları</h2>
    </div>
    <div class="header-actions">
        <button onclick="testEmail()" class="btn btn-info">
            <i class="fas fa-envelope"></i>
            <span>Email Test</span>
        </button>
        <button onclick="testAPI()" class="btn btn-success">
            <i class="fas fa-plug"></i>
            <span>API Test</span>
        </button>
    </div>
</div>

<?php if ($message): ?>
    <div class="alert alert-success">
        <i class="fas fa-check-circle"></i>
        <?php echo htmlspecialchars($message); ?>
    </div>
<?php endif; ?>

<?php if ($error): ?>
    <div class="alert alert-error">
        <i class="fas fa-exclamation-circle"></i>
        <?php echo htmlspecialchars($error); ?>
    </div>
<?php endif; ?>

<!-- Sistem Bilgileri -->
<div class="system-info">
    <h3><i class="fas fa-info-circle"></i> Sistem Bilgileri</h3>
    <div class="info-grid">
        <div class="info-card">
            <div class="info-icon">
                <i class="fas fa-server"></i>
            </div>
            <div class="info-content">
                <h4>Sunucu</h4>
                <p><?php echo htmlspecialchars($system_info['server_software']); ?></p>
            </div>
        </div>
        
        <div class="info-card">
            <div class="info-icon">
                <i class="fab fa-php"></i>
            </div>
            <div class="info-content">
                <h4>PHP Versiyonu</h4>
                <p><?php echo $system_info['php_version']; ?></p>
            </div>
        </div>
        
        <div class="info-card">
            <div class="info-icon">
                <i class="fas fa-database"></i>
            </div>
            <div class="info-content">
                <h4>Veritabanı</h4>
                <p><?php echo htmlspecialchars($system_info['database_version']); ?></p>
            </div>
        </div>
        
        <div class="info-card">
            <div class="info-icon">
                <i class="fas fa-hdd"></i>
            </div>
            <div class="info-content">
                <h4>Disk Alanı</h4>
                <p><?php echo formatBytes($system_info['disk_space']['used']); ?> / <?php echo formatBytes($system_info['disk_space']['total']); ?></p>
            </div>
        </div>
    </div>
</div>

<!-- Ayarlar Sekmeleri -->
<div class="settings-tabs">
    <div class="tab-nav">
        <button class="tab-btn <?php echo $action === 'general' ? 'active' : ''; ?>" onclick="showTab('general')">
            <i class="fas fa-cog"></i>
            <span>Genel</span>
        </button>
        <button class="tab-btn <?php echo $action === 'email' ? 'active' : ''; ?>" onclick="showTab('email')">
            <i class="fas fa-envelope"></i>
            <span>Email</span>
        </button>
        <button class="tab-btn <?php echo $action === 'notifications' ? 'active' : ''; ?>" onclick="showTab('notifications')">
            <i class="fas fa-bell"></i>
            <span>Bildirimler</span>
        </button>
        <button class="tab-btn <?php echo $action === 'security' ? 'active' : ''; ?>" onclick="showTab('security')">
            <i class="fas fa-shield-alt"></i>
            <span>Güvenlik</span>
        </button>
        <button class="tab-btn <?php echo $action === 'api' ? 'active' : ''; ?>" onclick="showTab('api')">
            <i class="fas fa-plug"></i>
            <span>API</span>
        </button>
    </div>
    
    <div class="tab-content">
        <!-- Genel Ayarlar -->
        <div id="general-tab" class="tab-pane <?php echo $action === 'general' ? 'active' : ''; ?>">
            <form method="post" action="">
                <input type="hidden" name="setting_type" value="general">
                
                <div class="form-section">
                    <h4><i class="fas fa-info-circle"></i> Temel Bilgiler</h4>
                    <div class="form-row">
                        <div class="form-group">
                            <label>Sistem Adı</label>
                            <input type="text" name="system_name" value="<?php echo htmlspecialchars($settings['system_name']); ?>" required>
                        </div>
                        <div class="form-group">
                            <label>Sistem Versiyonu</label>
                            <input type="text" name="system_version" value="<?php echo htmlspecialchars($settings['system_version']); ?>" required>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label>Sistem Açıklaması</label>
                        <textarea name="system_description" rows="3"><?php echo htmlspecialchars($settings['system_description']); ?></textarea>
                    </div>
                </div>
                
                <div class="form-section">
                    <h4><i class="fas fa-address-book"></i> İletişim Bilgileri</h4>
                    <div class="form-row">
                        <div class="form-group">
                            <label>Email</label>
                            <input type="email" name="contact_email" value="<?php echo htmlspecialchars($settings['contact_email']); ?>">
                        </div>
                        <div class="form-group">
                            <label>Telefon</label>
                            <input type="text" name="contact_phone" value="<?php echo htmlspecialchars($settings['contact_phone']); ?>">
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label>Adres</label>
                        <textarea name="address" rows="2"><?php echo htmlspecialchars($settings['address']); ?></textarea>
                    </div>
                </div>
                
                <div class="form-section">
                    <h4><i class="fas fa-globe"></i> Yerel Ayarlar</h4>
                    <div class="form-row">
                        <div class="form-group">
                            <label>Zaman Dilimi</label>
                            <select name="timezone">
                                <option value="Europe/Istanbul" <?php echo $settings['timezone'] === 'Europe/Istanbul' ? 'selected' : ''; ?>>Türkiye (UTC+3)</option>
                                <option value="Europe/London" <?php echo $settings['timezone'] === 'Europe/London' ? 'selected' : ''; ?>>Londra (UTC+0)</option>
                                <option value="America/New_York" <?php echo $settings['timezone'] === 'America/New_York' ? 'selected' : ''; ?>>New York (UTC-5)</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Tarih Formatı</label>
                            <select name="date_format">
                                <option value="d.m.Y" <?php echo $settings['date_format'] === 'd.m.Y' ? 'selected' : ''; ?>>DD.MM.YYYY</option>
                                <option value="Y-m-d" <?php echo $settings['date_format'] === 'Y-m-d' ? 'selected' : ''; ?>>YYYY-MM-DD</option>
                                <option value="m/d/Y" <?php echo $settings['date_format'] === 'm/d/Y' ? 'selected' : ''; ?>>MM/DD/YYYY</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label>Saat Formatı</label>
                            <select name="time_format">
                                <option value="H:i" <?php echo $settings['time_format'] === 'H:i' ? 'selected' : ''; ?>>24 Saat (HH:MM)</option>
                                <option value="h:i A" <?php echo $settings['time_format'] === 'h:i A' ? 'selected' : ''; ?>>12 Saat (HH:MM AM/PM)</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Para Birimi</label>
                            <select name="currency">
                                <option value="TRY" <?php echo $settings['currency'] === 'TRY' ? 'selected' : ''; ?>>Türk Lirası (TRY)</option>
                                <option value="USD" <?php echo $settings['currency'] === 'USD' ? 'selected' : ''; ?>>Amerikan Doları (USD)</option>
                                <option value="EUR" <?php echo $settings['currency'] === 'EUR' ? 'selected' : ''; ?>>Euro (EUR)</option>
                            </select>
                        </div>
                    </div>
                </div>
                
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i>
                        <span>Kaydet</span>
                    </button>
                </div>
            </form>
        </div>
        
        <!-- Email Ayarları -->
        <div id="email-tab" class="tab-pane <?php echo $action === 'email' ? 'active' : ''; ?>">
            <form method="post" action="">
                <input type="hidden" name="setting_type" value="email">
                
                <div class="form-section">
                    <h4><i class="fas fa-server"></i> SMTP Ayarları</h4>
                    <div class="form-row">
                        <div class="form-group">
                            <label>SMTP Sunucu</label>
                            <input type="text" name="smtp_host" value="<?php echo htmlspecialchars($settings['smtp_host']); ?>" placeholder="smtp.gmail.com">
                        </div>
                        <div class="form-group">
                            <label>SMTP Port</label>
                            <input type="number" name="smtp_port" value="<?php echo htmlspecialchars($settings['smtp_port']); ?>" placeholder="587">
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label>Kullanıcı Adı</label>
                            <input type="text" name="smtp_username" value="<?php echo htmlspecialchars($settings['smtp_username']); ?>" placeholder="your-email@gmail.com">
                        </div>
                        <div class="form-group">
                            <label>Şifre</label>
                            <input type="password" name="smtp_password" value="<?php echo htmlspecialchars($settings['smtp_password']); ?>" placeholder="App Password">
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label>Şifreleme</label>
                            <select name="smtp_encryption">
                                <option value="tls" <?php echo $settings['smtp_encryption'] === 'tls' ? 'selected' : ''; ?>>TLS</option>
                                <option value="ssl" <?php echo $settings['smtp_encryption'] === 'ssl' ? 'selected' : ''; ?>>SSL</option>
                                <option value="" <?php echo $settings['smtp_encryption'] === '' ? 'selected' : ''; ?>>Yok</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>
                                <input type="checkbox" name="email_enabled" value="1" <?php echo $settings['email_enabled'] ? 'checked' : ''; ?>>
                                Email Gönderimini Aktif Et
                            </label>
                        </div>
                    </div>
                </div>
                
                <div class="form-section">
                    <h4><i class="fas fa-envelope"></i> Gönderen Bilgileri</h4>
                    <div class="form-row">
                        <div class="form-group">
                            <label>Gönderen Email</label>
                            <input type="email" name="from_email" value="<?php echo htmlspecialchars($settings['from_email']); ?>" placeholder="noreply@baskent1910guksk.com">
                        </div>
                        <div class="form-group">
                            <label>Gönderen Adı</label>
                            <input type="text" name="from_name" value="<?php echo htmlspecialchars($settings['from_name']); ?>" placeholder="BAŞKENT 1910 GÜCÜ SK">
                        </div>
                    </div>
                </div>
                
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i>
                        <span>Kaydet</span>
                    </button>
                </div>
            </form>
        </div>
        
        <!-- Bildirim Ayarları -->
        <div id="notifications-tab" class="tab-pane <?php echo $action === 'notifications' ? 'active' : ''; ?>">
            <form method="post" action="">
                <input type="hidden" name="setting_type" value="notifications">
                
                <div class="form-section">
                    <h4><i class="fas fa-bell"></i> Bildirim Türleri</h4>
                    <div class="checkbox-grid">
                        <div class="checkbox-item">
                            <label>
                                <input type="checkbox" name="push_notifications_enabled" value="1" <?php echo $settings['push_notifications_enabled'] ? 'checked' : ''; ?>>
                                <span class="checkmark"></span>
                                Push Bildirimleri
                            </label>
                        </div>
                        <div class="checkbox-item">
                            <label>
                                <input type="checkbox" name="email_notifications_enabled" value="1" <?php echo $settings['email_notifications_enabled'] ? 'checked' : ''; ?>>
                                <span class="checkmark"></span>
                                Email Bildirimleri
                            </label>
                        </div>
                        <div class="checkbox-item">
                            <label>
                                <input type="checkbox" name="sms_notifications_enabled" value="1" <?php echo $settings['sms_notifications_enabled'] ? 'checked' : ''; ?>>
                                <span class="checkmark"></span>
                                SMS Bildirimleri
                            </label>
                        </div>
                    </div>
                </div>
                
                <div class="form-section">
                    <h4><i class="fas fa-volume-up"></i> Bildirim Özellikleri</h4>
                    <div class="checkbox-grid">
                        <div class="checkbox-item">
                            <label>
                                <input type="checkbox" name="notification_sound" value="1" <?php echo $settings['notification_sound'] ? 'checked' : ''; ?>>
                                <span class="checkmark"></span>
                                Bildirim Sesi
                            </label>
                        </div>
                        <div class="checkbox-item">
                            <label>
                                <input type="checkbox" name="notification_vibration" value="1" <?php echo $settings['notification_vibration'] ? 'checked' : ''; ?>>
                                <span class="checkmark"></span>
                                Titreşim
                            </label>
                        </div>
                    </div>
                </div>
                
                <div class="form-section">
                    <h4><i class="fas fa-database"></i> Yedekleme Ayarları</h4>
                    <div class="checkbox-grid">
                        <div class="checkbox-item">
                            <label>
                                <input type="checkbox" name="auto_backup_enabled" value="1" <?php echo $settings['auto_backup_enabled'] ? 'checked' : ''; ?>>
                                <span class="checkmark"></span>
                                Otomatik Yedekleme
                            </label>
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label>Yedekleme Sıklığı</label>
                            <select name="backup_frequency">
                                <option value="hourly" <?php echo $settings['backup_frequency'] === 'hourly' ? 'selected' : ''; ?>>Saatlik</option>
                                <option value="daily" <?php echo $settings['backup_frequency'] === 'daily' ? 'selected' : ''; ?>>Günlük</option>
                                <option value="weekly" <?php echo $settings['backup_frequency'] === 'weekly' ? 'selected' : ''; ?>>Haftalık</option>
                                <option value="monthly" <?php echo $settings['backup_frequency'] === 'monthly' ? 'selected' : ''; ?>>Aylık</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Yedekleme Saklama Süresi (Gün)</label>
                            <input type="number" name="backup_retention" value="<?php echo htmlspecialchars($settings['backup_retention']); ?>" min="1" max="365">
                        </div>
                    </div>
                </div>
                
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i>
                        <span>Kaydet</span>
                    </button>
                </div>
            </form>
        </div>
        
        <!-- Güvenlik Ayarları -->
        <div id="security-tab" class="tab-pane <?php echo $action === 'security' ? 'active' : ''; ?>">
            <form method="post" action="">
                <input type="hidden" name="setting_type" value="security">
                
                <div class="form-section">
                    <h4><i class="fas fa-user-lock"></i> Oturum Ayarları</h4>
                    <div class="form-row">
                        <div class="form-group">
                            <label>Oturum Zaman Aşımı (Saniye)</label>
                            <input type="number" name="session_timeout" value="<?php echo htmlspecialchars($settings['session_timeout']); ?>" min="300" max="86400">
                        </div>
                        <div class="form-group">
                            <label>Maksimum Giriş Denemesi</label>
                            <input type="number" name="max_login_attempts" value="<?php echo htmlspecialchars($settings['max_login_attempts']); ?>" min="3" max="10">
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label>Kilitleme Süresi (Saniye)</label>
                        <input type="number" name="lockout_duration" value="<?php echo htmlspecialchars($settings['lockout_duration']); ?>" min="60" max="3600">
                    </div>
                </div>
                
                <div class="form-section">
                    <h4><i class="fas fa-key"></i> Şifre Ayarları</h4>
                    <div class="form-row">
                        <div class="form-group">
                            <label>Minimum Şifre Uzunluğu</label>
                            <input type="number" name="password_min_length" value="<?php echo htmlspecialchars($settings['password_min_length']); ?>" min="6" max="20">
                        </div>
                        <div class="form-group">
                            <label>
                                <input type="checkbox" name="password_require_special" value="1" <?php echo $settings['password_require_special'] ? 'checked' : ''; ?>>
                                Özel Karakter Gerekli
                            </label>
                        </div>
                    </div>
                </div>
                
                <div class="form-section">
                    <h4><i class="fas fa-shield-alt"></i> Güvenlik Özellikleri</h4>
                    <div class="checkbox-grid">
                        <div class="checkbox-item">
                            <label>
                                <input type="checkbox" name="two_factor_enabled" value="1" <?php echo $settings['two_factor_enabled'] ? 'checked' : ''; ?>>
                                <span class="checkmark"></span>
                                İki Faktörlü Kimlik Doğrulama
                            </label>
                        </div>
                        <div class="checkbox-item">
                            <label>
                                <input type="checkbox" name="maintenance_mode" value="1" <?php echo $settings['maintenance_mode'] ? 'checked' : ''; ?>>
                                <span class="checkmark"></span>
                                Bakım Modu
                            </label>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label>IP Beyaz Liste (Her satıra bir IP)</label>
                        <textarea name="ip_whitelist" rows="5" placeholder="192.168.1.1&#10;10.0.0.1"><?php echo htmlspecialchars($settings['ip_whitelist']); ?></textarea>
                    </div>
                </div>
                
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i>
                        <span>Kaydet</span>
                    </button>
                </div>
            </form>
        </div>
        
        <!-- API Ayarları -->
        <div id="api-tab" class="tab-pane <?php echo $action === 'api' ? 'active' : ''; ?>">
            <form method="post" action="">
                <input type="hidden" name="setting_type" value="api">
                
                <div class="form-section">
                    <h4><i class="fas fa-plug"></i> API Genel Ayarları</h4>
                    <div class="checkbox-grid">
                        <div class="checkbox-item">
                            <label>
                                <input type="checkbox" name="api_enabled" value="1" <?php echo $settings['api_enabled'] ? 'checked' : ''; ?>>
                                <span class="checkmark"></span>
                                API'yi Aktif Et
                            </label>
                        </div>
                        <div class="checkbox-item">
                            <label>
                                <input type="checkbox" name="cors_enabled" value="1" <?php echo $settings['cors_enabled'] ? 'checked' : ''; ?>>
                                <span class="checkmark"></span>
                                CORS Desteği
                            </label>
                        </div>
                        <div class="checkbox-item">
                            <label>
                                <input type="checkbox" name="api_logging" value="1" <?php echo $settings['api_logging'] ? 'checked' : ''; ?>>
                                <span class="checkmark"></span>
                                API Loglama
                            </label>
                        </div>
                    </div>
                </div>
                
                <div class="form-section">
                    <h4><i class="fas fa-tachometer-alt"></i> Rate Limiting</h4>
                    <div class="form-row">
                        <div class="form-group">
                            <label>İstek Limiti</label>
                            <input type="number" name="api_rate_limit" value="<?php echo htmlspecialchars($settings['api_rate_limit']); ?>" min="10" max="1000">
                        </div>
                        <div class="form-group">
                            <label>Zaman Penceresi (Saniye)</label>
                            <input type="number" name="api_rate_window" value="<?php echo htmlspecialchars($settings['api_rate_window']); ?>" min="60" max="86400">
                        </div>
                    </div>
                </div>
                
                <div class="form-section">
                    <h4><i class="fas fa-key"></i> JWT Ayarları</h4>
                    <div class="form-row">
                        <div class="form-group">
                            <label>JWT Secret Key</label>
                            <input type="text" name="jwt_secret" value="<?php echo htmlspecialchars($settings['jwt_secret']); ?>" placeholder="Güçlü bir secret key girin">
                        </div>
                        <div class="form-group">
                            <label>JWT Süresi (Saniye)</label>
                            <input type="number" name="jwt_expiry" value="<?php echo htmlspecialchars($settings['jwt_expiry']); ?>" min="300" max="86400">
                        </div>
                    </div>
                </div>
                
                <div class="form-section">
                    <h4><i class="fas fa-globe"></i> CORS Ayarları</h4>
                    <div class="form-group">
                        <label>İzin Verilen Origin'ler (Virgülle ayırın)</label>
                        <input type="text" name="cors_origins" value="<?php echo htmlspecialchars($settings['cors_origins']); ?>" placeholder="https://app.example.com,https://admin.example.com">
                    </div>
                </div>
                
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i>
                        <span>Kaydet</span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function showTab(tabName) {
    // Tüm tab'ları gizle
    document.querySelectorAll('.tab-pane').forEach(tab => {
        tab.classList.remove('active');
    });
    
    // Tüm tab butonlarını pasif yap
    document.querySelectorAll('.tab-btn').forEach(btn => {
        btn.classList.remove('active');
    });
    
    // Seçilen tab'ı göster
    document.getElementById(tabName + '-tab').classList.add('active');
    
    // Seçilen tab butonunu aktif yap
    event.target.classList.add('active');
    
    // URL'yi güncelle
    const url = new URL(window.location);
    url.searchParams.set('action', tabName);
    window.history.pushState({}, '', url);
}

function testEmail() {
    // Email test fonksiyonu
    alert('Email test özelliği yakında eklenecek!');
}

function testAPI() {
    // API test fonksiyonu
    alert('API test özelliği yakında eklenecek!');
}

function formatBytes(bytes) {
    if (bytes === 0) return '0 Bytes';
    const k = 1024;
    const sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB'];
    const i = Math.floor(Math.log(bytes) / Math.log(k));
    return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];
}
</script>

<?php
// Yardımcı fonksiyonlar
function formatBytes($bytes, $precision = 2) {
    $units = array('B', 'KB', 'MB', 'GB', 'TB');
    
    for ($i = 0; $bytes > 1024 && $i < count($units) - 1; $i++) {
        $bytes /= 1024;
    }
    
    return round($bytes, $precision) . ' ' . $units[$i];
}
?>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
