<?php
$page_title = 'Email Sistemi - BAŞKENT 1910 GÜCÜ SK';
require_once __DIR__ . '/../includes/header.php';

$message = '';
$error = '';

// Email gönderimi
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $to_emails = $_POST['to_emails'] ?? '';
    $subject = $_POST['subject'] ?? '';
    $message_content = $_POST['message'] ?? '';
    
    if (empty($to_emails) || empty($subject) || empty($message_content)) {
        $error = 'Gerekli alanlar boş bırakılamaz!';
    } else {
        // Email geçmişini kaydet
        try {
            $stmt = $pdo->prepare("
                INSERT INTO email_history (subject, message, recipient_count, success_count, error_count, sent_by, sent_at) 
                VALUES (?, ?, ?, ?, ?, ?, NOW())
            ");
            $stmt->execute([
                $subject,
                $message_content,
                1, // recipient_count
                1, // success_count
                0, // error_count
                $_SESSION['admin_id']
            ]);
            
            $message = "Email başarıyla kaydedildi! (Simülasyon)";
        } catch (Exception $e) {
            $error = "Hata: " . $e->getMessage();
        }
    }
}

// Email geçmişi
$email_history = $pdo->query("
    SELECT eh.*, u.full_name as sent_by_name
    FROM email_history eh
    LEFT JOIN users u ON eh.sent_by = u.id
    ORDER BY eh.sent_at DESC
    LIMIT 20
")->fetchAll();

// Email istatistikleri
$email_stats = [];
$stmt = $pdo->query("
    SELECT 
        COUNT(*) as total_emails,
        SUM(success_count) as total_sent,
        SUM(error_count) as total_errors,
        COUNT(CASE WHEN sent_at >= DATE_SUB(NOW(), INTERVAL 7 DAY) THEN 1 END) as last_week_emails
    FROM email_history
");
$email_stats = $stmt->fetch();
?>

<div class="page-header">
    <div class="page-title">
        <i class="fas fa-envelope"></i>
        <h2>Email Sistemi</h2>
    </div>
    <div class="header-actions">
        <button onclick="testEmail()" class="btn btn-info">
            <i class="fas fa-vial"></i>
            <span>Email Test</span>
        </button>
    </div>
</div>

<?php if ($message): ?>
    <div class="alert alert-success">
        <i class="fas fa-check-circle"></i>
        <?php echo htmlspecialchars($message); ?>
    </div>
<?php endif; ?>

<?php if ($error): ?>
    <div class="alert alert-error">
        <i class="fas fa-exclamation-circle"></i>
        <?php echo htmlspecialchars($error); ?>
    </div>
<?php endif; ?>

<!-- Email İstatistikleri -->
<div class="email-stats">
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-envelope"></i>
            </div>
            <div class="stat-content">
                <h3><?php echo $email_stats['total_emails'] ?? 0; ?></h3>
                <p>Toplam Email</p>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-paper-plane"></i>
            </div>
            <div class="stat-content">
                <h3><?php echo $email_stats['total_sent'] ?? 0; ?></h3>
                <p>Gönderilen</p>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-exclamation-triangle"></i>
            </div>
            <div class="stat-content">
                <h3><?php echo $email_stats['total_errors'] ?? 0; ?></h3>
                <p>Hatalı</p>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-calendar-week"></i>
            </div>
            <div class="stat-content">
                <h3><?php echo $email_stats['last_week_emails'] ?? 0; ?></h3>
                <p>Son 7 Gün</p>
            </div>
        </div>
    </div>
</div>

<!-- Email Gönderim Formu -->
<div class="email-compose">
    <h3><i class="fas fa-edit"></i> Email Gönder</h3>
    
    <form method="post" action="">
        <div class="form-row">
            <div class="form-group">
                <label>Alıcılar</label>
                <select name="to_emails" id="to_emails">
                    <option value="all_parents">Tüm Veliler</option>
                    <option value="all_athletes">Sporcu Velileri</option>
                    <option value="custom">Özel Email Listesi</option>
                </select>
            </div>
        </div>
        
        <div class="form-group">
            <label>Konu</label>
            <input type="text" name="subject" required placeholder="Email konusu">
        </div>
        
        <div class="form-group">
            <label>Mesaj</label>
            <textarea name="message" rows="8" required placeholder="Email mesajınızı yazın..."></textarea>
        </div>
        
        <div class="form-actions">
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-paper-plane"></i>
                <span>Email Gönder</span>
            </button>
            <button type="button" class="btn btn-secondary" onclick="clearForm()">
                <i class="fas fa-times"></i>
                <span>Temizle</span>
            </button>
        </div>
    </form>
</div>

<!-- Email Geçmişi -->
<div class="email-history">
    <div class="table-header">
        <h3><i class="fas fa-history"></i> Email Geçmişi</h3>
    </div>
    
    <table class="data-table">
        <thead>
            <tr>
                <th>Konu</th>
                <th>Alıcı Sayısı</th>
                <th>Başarılı</th>
                <th>Hatalı</th>
                <th>Gönderen</th>
                <th>Tarih</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($email_history as $email): ?>
                <tr>
                    <td>
                        <div class="email-info">
                            <i class="fas fa-envelope"></i>
                            <span><?php echo htmlspecialchars($email['subject']); ?></span>
                        </div>
                    </td>
                    <td><?php echo $email['recipient_count']; ?></td>
                    <td>
                        <span class="status status-success"><?php echo $email['success_count']; ?></span>
                    </td>
                    <td>
                        <span class="status status-error"><?php echo $email['error_count']; ?></span>
                    </td>
                    <td><?php echo htmlspecialchars($email['sent_by_name'] ?? 'Sistem'); ?></td>
                    <td><?php echo date('d.m.Y H:i', strtotime($email['sent_at'])); ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<script>
function clearForm() {
    document.querySelector('input[name="subject"]').value = '';
    document.querySelector('textarea[name="message"]').value = '';
}

function testEmail() {
    alert('Email test özelliği yakında eklenecek!');
}
</script>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>






