<?php
$page_title = 'Veli Yönetimi - BAŞKENT 1910 GÜCÜ SK';
require_once __DIR__ . '/../includes/header.php';

$action = $_GET['action'] ?? 'list';
$message = '';
$error = '';

// Veli ekleme/düzenleme işlemleri
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = trim($_POST['password'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $full_name = trim($_POST['full_name'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    
    if ($username && $password && $email && $full_name) {
        try {
            // Kullanıcı adı kontrolü
            $stmt = $pdo->prepare("SELECT id FROM users WHERE username = ?");
            $stmt->execute([$username]);
            if ($stmt->fetch() && $action === 'add') {
                $error = "Bu kullanıcı adı zaten kullanılıyor!";
            } else {
                $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                
                if ($action === 'add') {
                    $stmt = $pdo->prepare("INSERT INTO users (username, password, email, full_name, phone, user_type) VALUES (?, ?, ?, ?, ?, 'veli')");
                    $stmt->execute([$username, $hashed_password, $email, $full_name, $phone]);
                    $message = "Veli başarıyla eklendi!";
                } elseif ($action === 'edit' && isset($_GET['id'])) {
                    if ($password) {
                        $stmt = $pdo->prepare("UPDATE users SET username=?, password=?, email=?, full_name=?, phone=? WHERE id=? AND user_type='veli'");
                        $stmt->execute([$username, $hashed_password, $email, $full_name, $phone, $_GET['id']]);
                    } else {
                        $stmt = $pdo->prepare("UPDATE users SET username=?, email=?, full_name=?, phone=? WHERE id=? AND user_type='veli'");
                        $stmt->execute([$username, $email, $full_name, $phone, $_GET['id']]);
                    }
                    $message = "Veli bilgileri güncellendi!";
                }
            }
        } catch (Exception $e) {
            $error = "Hata: " . $e->getMessage();
        }
    } else {
        $error = "Kullanıcı adı, şifre, email ve ad soyad zorunludur!";
    }
}

// Veli silme işlemi
if ($action === 'delete' && isset($_GET['id'])) {
    try {
        // Önce sporcuları kontrol et
        $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM athletes WHERE parent_id = ?");
        $stmt->execute([$_GET['id']]);
        $athlete_count = $stmt->fetch()['count'];
        
        if ($athlete_count > 0) {
            $error = "Bu velinin kayıtlı sporcuları var. Önce sporcuları başka veliye atayın!";
        } else {
            $stmt = $pdo->prepare("DELETE FROM users WHERE id = ? AND user_type = 'veli'");
            $stmt->execute([$_GET['id']]);
            $message = "Veli silindi!";
        }
    } catch (Exception $e) {
        $error = "Hata: " . $e->getMessage();
    }
}

// Veli listesi
$parents = $pdo->query("
    SELECT u.*, COUNT(a.id) as athlete_count 
    FROM users u 
    LEFT JOIN athletes a ON u.id = a.parent_id 
    WHERE u.user_type = 'veli' 
    GROUP BY u.id 
    ORDER BY u.full_name
")->fetchAll();

// Düzenleme için veli bilgileri
$edit_parent = null;
if ($action === 'edit' && isset($_GET['id'])) {
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ? AND user_type = 'veli'");
    $stmt->execute([$_GET['id']]);
    $edit_parent = $stmt->fetch();
}
?>

<div class="page-header">
    <div class="page-title">
        <i class="fas fa-user-friends"></i>
        <h2>Veli Yönetimi</h2>
    </div>
    <a href="?action=add" class="btn btn-primary">
        <i class="fas fa-user-plus"></i>
        <span>Yeni Veli Ekle</span>
    </a>
</div>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>

<?php if ($error): ?>
    <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<?php if ($action === 'add' || $action === 'edit'): ?>
    <div class="form-container">
        <h3>
            <i class="fas fa-<?php echo $action === 'add' ? 'user-plus' : 'user-edit'; ?>"></i>
            <?php echo $action === 'add' ? 'Yeni Veli Ekle' : 'Veli Düzenle'; ?>
        </h3>
        
        <form method="post" action="">
            <div class="form-row">
                <div class="form-group">
                    <label>Kullanıcı Adı *</label>
                    <input type="text" name="username" value="<?php echo htmlspecialchars($edit_parent['username'] ?? ''); ?>" required>
                </div>
                <div class="form-group">
                    <label>Şifre <?php echo $action === 'edit' ? '(Boş bırakırsanız değişmez)' : '*'; ?></label>
                    <input type="password" name="password" <?php echo $action === 'add' ? 'required' : ''; ?>>
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-group">
                    <label>Email *</label>
                    <input type="email" name="email" value="<?php echo htmlspecialchars($edit_parent['email'] ?? ''); ?>" required>
                </div>
                <div class="form-group">
                    <label>Ad Soyad *</label>
                    <input type="text" name="full_name" value="<?php echo htmlspecialchars($edit_parent['full_name'] ?? ''); ?>" required>
                </div>
            </div>
            
            <div class="form-group">
                <label>Telefon</label>
                <input type="text" name="phone" value="<?php echo htmlspecialchars($edit_parent['phone'] ?? ''); ?>">
            </div>
            
            <div class="form-actions">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-<?php echo $action === 'add' ? 'plus' : 'save'; ?>"></i>
                    <span><?php echo $action === 'add' ? 'Ekle' : 'Güncelle'; ?></span>
                </button>
                <a href="?" class="btn btn-secondary">
                    <i class="fas fa-times"></i>
                    <span>İptal</span>
                </a>
            </div>
        </form>
    </div>
<?php else: ?>
    <div class="table-container">
        <table class="data-table">
            <thead>
                <tr>
                    <th>Kullanıcı Adı</th>
                    <th>Ad Soyad</th>
                    <th>Email</th>
                    <th>Telefon</th>
                    <th>Sporcu Sayısı</th>
                    <th>Kayıt Tarihi</th>
                    <th>İşlemler</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($parents as $parent): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($parent['username']); ?></td>
                        <td><?php echo htmlspecialchars($parent['full_name']); ?></td>
                        <td><?php echo htmlspecialchars($parent['email']); ?></td>
                        <td><?php echo htmlspecialchars($parent['phone'] ?? '-'); ?></td>
                        <td><?php echo $parent['athlete_count']; ?></td>
                        <td><?php echo date('d.m.Y', strtotime($parent['created_at'])); ?></td>
                        <td>
                            <a href="?action=edit&id=<?php echo $parent['id']; ?>" class="btn btn-sm btn-secondary">
                                <i class="fas fa-edit"></i>
                                <span>Düzenle</span>
                            </a>
                            <a href="?action=delete&id=<?php echo $parent['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Emin misiniz?')">
                                <i class="fas fa-trash"></i>
                                <span>Sil</span>
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
<?php endif; ?>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>