<?php
$page_title = 'Bildirim Yönetimi - BAŞKENT 1910 GÜCÜ SK';
require_once __DIR__ . '/../includes/header.php';

$action = $_GET['action'] ?? 'list';
$message = '';
$error = '';

// Bildirim gönderme işlemi
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = trim($_POST['title'] ?? '');
    $message_text = trim($_POST['message'] ?? '');
    $target_type = $_POST['target_type'] ?? 'all';
    $target_users = $_POST['target_users'] ?? [];
    
    if ($title && $message_text) {
        try {
            // Hedef kullanıcıları JSON olarak kaydet
            $target_users_json = $target_type === 'all' ? null : json_encode($target_users);
            
            $stmt = $pdo->prepare("INSERT INTO notifications (title, message, target_type, target_users, created_by) VALUES (?, ?, ?, ?, ?)");
            $stmt->execute([$title, $message_text, $target_type, $target_users_json, $_SESSION['admin_id']]);
            
            // Burada gerçek push notification gönderimi yapılacak
            // Şimdilik sadece veritabanına kaydediyoruz
            $message = "Bildirim başarıyla oluşturuldu! (Push notification sistemi henüz aktif değil)";
        } catch (Exception $e) {
            $error = "Hata: " . $e->getMessage();
        }
    } else {
        $error = "Başlık ve mesaj zorunludur!";
    }
}

// Bildirim silme işlemi
if ($action === 'delete' && isset($_GET['id'])) {
    try {
        $stmt = $pdo->prepare("DELETE FROM notifications WHERE id = ?");
        $stmt->execute([$_GET['id']]);
        $message = "Bildirim silindi!";
    } catch (Exception $e) {
        $error = "Hata: " . $e->getMessage();
    }
}

// Veli listesi (seçim için)
$parents = $pdo->query("SELECT id, full_name FROM users WHERE user_type = 'veli' ORDER BY full_name")->fetchAll();

// Bildirim listesi
$notifications = $pdo->query("
    SELECT n.*, u.full_name as created_by_name 
    FROM notifications n 
    LEFT JOIN users u ON n.created_by = u.id 
    ORDER BY n.created_at DESC
")->fetchAll();
?>

<div class="page-header">
    <div class="page-title">
        <i class="fas fa-bell"></i>
        <h2>Bildirim Yönetimi</h2>
    </div>
    <a href="?action=send" class="btn btn-primary">
        <i class="fas fa-paper-plane"></i>
        <span>Yeni Bildirim Gönder</span>
    </a>
</div>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>

<?php if ($error): ?>
    <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<?php if ($action === 'send'): ?>
    <div class="form-container">
        <h3>
            <i class="fas fa-paper-plane"></i>
            Yeni Bildirim Gönder
        </h3>
        
        <form method="post" action="">
            <div class="form-group">
                <label>Bildirim Başlığı *</label>
                <input type="text" name="title" placeholder="Örn: Antrenman İptali" required>
            </div>
            
            <div class="form-group">
                <label>Mesaj *</label>
                <textarea name="message" rows="5" placeholder="Bildirim mesajınızı buraya yazın..." required></textarea>
            </div>
            
            <div class="form-group">
                <label>Hedef Kitle</label>
                <select name="target_type" id="target_type" onchange="toggleUserSelection()">
                    <option value="all">Tüm Veliler</option>
                    <option value="specific">Belirli Veliler</option>
                </select>
            </div>
            
            <div class="form-group" id="user_selection" style="display: none;">
                <label>Veli Seçimi</label>
                <div class="checkbox-group">
                    <?php foreach ($parents as $parent): ?>
                        <label class="checkbox-label">
                            <input type="checkbox" name="target_users[]" value="<?php echo $parent['id']; ?>">
                            <?php echo htmlspecialchars($parent['full_name']); ?>
                        </label>
                    <?php endforeach; ?>
                </div>
            </div>
            
            <div class="form-actions">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-paper-plane"></i>
                    <span>Bildirim Gönder</span>
                </button>
                <a href="?" class="btn btn-secondary">
                    <i class="fas fa-times"></i>
                    <span>İptal</span>
                </a>
            </div>
        </form>
    </div>
<?php else: ?>
    <div class="table-container">
        <table class="data-table">
            <thead>
                <tr>
                    <th>Başlık</th>
                    <th>Mesaj</th>
                    <th>Hedef</th>
                    <th>Gönderen</th>
                    <th>Tarih</th>
                    <th>Durum</th>
                    <th>İşlemler</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($notifications as $notification): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($notification['title']); ?></td>
                        <td><?php echo htmlspecialchars(substr($notification['message'], 0, 50)) . (strlen($notification['message']) > 50 ? '...' : ''); ?></td>
                        <td>
                            <?php if ($notification['target_type'] === 'all'): ?>
                                <span class="status status-all">Tüm Veliler</span>
                            <?php else: ?>
                                <span class="status status-specific">Belirli Veliler</span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo htmlspecialchars($notification['created_by_name'] ?? 'Sistem'); ?></td>
                        <td><?php echo date('d.m.Y H:i', strtotime($notification['created_at'])); ?></td>
                        <td>
                            <?php if ($notification['sent_at']): ?>
                                <span class="status status-sent">Gönderildi</span>
                            <?php else: ?>
                                <span class="status status-pending">Beklemede</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <a href="?action=delete&id=<?php echo $notification['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Emin misiniz?')">
                                <i class="fas fa-trash"></i>
                                <span>Sil</span>
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
<?php endif; ?>

<script>
function toggleUserSelection() {
    const targetType = document.getElementById('target_type').value;
    const userSelection = document.getElementById('user_selection');
    
    if (targetType === 'specific') {
        userSelection.style.display = 'block';
    } else {
        userSelection.style.display = 'none';
    }
}
</script>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>