<?php
$page_title = 'Yoklama Yönetimi - BAŞKENT 1910 GÜCÜ SK';
require_once __DIR__ . '/../includes/header.php';

$action = $_GET['action'] ?? 'list';
$message = '';
$error = '';

// Yoklama ekleme/düzenleme işlemleri
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $athlete_id = $_POST['athlete_id'] ?? '';
    $training_date = $_POST['training_date'] ?? '';
    $status = $_POST['status'] ?? 'present';
    $notes = trim($_POST['notes'] ?? '');
    
    if ($athlete_id && $training_date) {
        try {
            // Tarihten yıl ve ay çıkar
            $date = new DateTime($training_date);
            $year = $date->format('Y');
            $month = $date->format('n');
            
            if ($action === 'add') {
                // Aynı sporcu ve tarih için kayıt var mı kontrol et
                $stmt = $pdo->prepare("SELECT id FROM attendance WHERE athlete_id = ? AND training_date = ?");
                $stmt->execute([$athlete_id, $training_date]);
                if ($stmt->fetch()) {
                    $error = "Bu sporcu için bu tarihte zaten yoklama kaydı var!";
                } else {
                    $stmt = $pdo->prepare("INSERT INTO attendance (athlete_id, training_date, year, month, status, notes, created_by) VALUES (?, ?, ?, ?, ?, ?, ?)");
                    $stmt->execute([$athlete_id, $training_date, $year, $month, $status, $notes, $_SESSION['admin_id']]);
                    $message = "Yoklama kaydı eklendi!";
                }
            } elseif ($action === 'edit' && isset($_GET['id'])) {
                $stmt = $pdo->prepare("UPDATE attendance SET athlete_id=?, training_date=?, year=?, month=?, status=?, notes=? WHERE id=?");
                $stmt->execute([$athlete_id, $training_date, $year, $month, $status, $notes, $_GET['id']]);
                $message = "Yoklama kaydı güncellendi!";
            }
        } catch (Exception $e) {
            $error = "Hata: " . $e->getMessage();
        }
    } else {
        $error = "Sporcu ve tarih zorunludur!";
    }
}

// Yoklama silme işlemi
if ($action === 'delete' && isset($_GET['id'])) {
    try {
        $stmt = $pdo->prepare("DELETE FROM attendance WHERE id = ?");
        $stmt->execute([$_GET['id']]);
        $message = "Yoklama kaydı silindi!";
    } catch (Exception $e) {
        $error = "Hata: " . $e->getMessage();
    }
}

// Sporcu listesi (dropdown için)
$athletes = $pdo->query("SELECT id, first_name, last_name FROM athletes WHERE status = 'active' ORDER BY first_name, last_name")->fetchAll();

// Yoklama listesi
$attendance = $pdo->query("
    SELECT a.*, ath.first_name, ath.last_name 
    FROM attendance a 
    JOIN athletes ath ON a.athlete_id = ath.id 
    ORDER BY a.training_date DESC, ath.first_name, ath.last_name
")->fetchAll();

// Düzenleme için yoklama bilgileri
$edit_attendance = null;
if ($action === 'edit' && isset($_GET['id'])) {
    $stmt = $pdo->prepare("SELECT * FROM attendance WHERE id = ?");
    $stmt->execute([$_GET['id']]);
    $edit_attendance = $stmt->fetch();
}

// Bugünün tarihi
$today = date('Y-m-d');
?>

<div class="page-header">
    <div class="page-title">
        <i class="fas fa-clipboard-check"></i>
        <h2>Yoklama Yönetimi</h2>
    </div>
    <a href="?action=add" class="btn btn-primary">
        <i class="fas fa-plus"></i>
        <span>Yoklama Ekle</span>
    </a>
</div>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>

<?php if ($error): ?>
    <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<?php if ($action === 'add' || $action === 'edit'): ?>
    <div class="form-container">
        <h3>
            <i class="fas fa-<?php echo $action === 'add' ? 'plus' : 'edit'; ?>"></i>
            <?php echo $action === 'add' ? 'Yeni Yoklama Kaydı' : 'Yoklama Kaydı Düzenle'; ?>
        </h3>
        
        <form method="post" action="">
            <div class="form-row">
                <div class="form-group">
                    <label>Sporcu *</label>
                    <select name="athlete_id" required>
                        <option value="">Sporcu Seçin</option>
                        <?php foreach ($athletes as $athlete): ?>
                            <option value="<?php echo $athlete['id']; ?>" <?php echo ($edit_attendance['athlete_id'] ?? '') == $athlete['id'] ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($athlete['first_name'] . ' ' . $athlete['last_name']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label>Antrenman Tarihi *</label>
                    <input type="date" name="training_date" value="<?php echo $edit_attendance['training_date'] ?? $today; ?>" required>
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-group">
                    <label>Durum *</label>
                    <select name="status" required>
                        <option value="present" <?php echo ($edit_attendance['status'] ?? '') == 'present' ? 'selected' : ''; ?>>Geldi</option>
                        <option value="absent" <?php echo ($edit_attendance['status'] ?? '') == 'absent' ? 'selected' : ''; ?>>Gelmedi</option>
                        <option value="excused" <?php echo ($edit_attendance['status'] ?? '') == 'excused' ? 'selected' : ''; ?>>Mazeretli</option>
                    </select>
                </div>
            </div>
            
            <div class="form-group">
                <label>Notlar</label>
                <textarea name="notes" rows="3" placeholder="Yoklama hakkında notlar..."><?php echo htmlspecialchars($edit_attendance['notes'] ?? ''); ?></textarea>
            </div>
            
            <div class="form-actions">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-<?php echo $action === 'add' ? 'plus' : 'save'; ?>"></i>
                    <span><?php echo $action === 'add' ? 'Ekle' : 'Güncelle'; ?></span>
                </button>
                <a href="?" class="btn btn-secondary">
                    <i class="fas fa-times"></i>
                    <span>İptal</span>
                </a>
            </div>
        </form>
    </div>
<?php else: ?>
    <div class="table-container">
        <table class="data-table">
            <thead>
                <tr>
                    <th>Sporcu</th>
                    <th>Tarih</th>
                    <th>Durum</th>
                    <th>Notlar</th>
                    <th>Kayıt Tarihi</th>
                    <th>İşlemler</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($attendance as $record): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($record['first_name'] . ' ' . $record['last_name']); ?></td>
                        <td><?php echo date('d.m.Y', strtotime($record['training_date'])); ?></td>
                        <td>
                            <span class="status status-<?php echo $record['status']; ?>">
                                <?php 
                                $status_text = [
                                    'present' => 'Geldi',
                                    'absent' => 'Gelmedi',
                                    'excused' => 'Mazeretli'
                                ];
                                echo $status_text[$record['status']] ?? $record['status'];
                                ?>
                            </span>
                        </td>
                        <td><?php echo htmlspecialchars($record['notes'] ?? '-'); ?></td>
                        <td><?php echo date('d.m.Y H:i', strtotime($record['created_at'])); ?></td>
                        <td>
                            <a href="?action=edit&id=<?php echo $record['id']; ?>" class="btn btn-sm btn-secondary">
                                <i class="fas fa-edit"></i>
                                <span>Düzenle</span>
                            </a>
                            <a href="?action=delete&id=<?php echo $record['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Emin misiniz?')">
                                <i class="fas fa-trash"></i>
                                <span>Sil</span>
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
<?php endif; ?>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>