<?php
$page_title = 'Sporcu Yönetimi - BAŞKENT 1910 GÜCÜ SK';
require_once __DIR__ . '/../includes/header.php';

$action = $_GET['action'] ?? 'list';
$message = '';
$error = '';

// Sporcu ekleme/düzenleme işlemleri
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $first_name = trim($_POST['first_name'] ?? '');
    $last_name = trim($_POST['last_name'] ?? '');
    $birth_date = $_POST['birth_date'] ?? '';
    $parent_id = $_POST['parent_id'] ?? '';
    $phone = trim($_POST['phone'] ?? '');
    $address = trim($_POST['address'] ?? '');
    $emergency_contact = trim($_POST['emergency_contact'] ?? '');
    
    if ($first_name && $last_name && $birth_date) {
        try {
            // Yaş hesapla
            $birthDate = new DateTime($birth_date);
            $today = new DateTime();
            $age = $today->diff($birthDate)->y;
            
            if ($action === 'add') {
                $stmt = $pdo->prepare("INSERT INTO athletes (first_name, last_name, birth_date, age, parent_id, phone, address, emergency_contact) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
                $stmt->execute([$first_name, $last_name, $birth_date, $age, $parent_id ?: null, $phone, $address, $emergency_contact]);
                $message = "Sporcu başarıyla eklendi!";
            } elseif ($action === 'edit' && isset($_GET['id'])) {
                $stmt = $pdo->prepare("UPDATE athletes SET first_name=?, last_name=?, birth_date=?, age=?, parent_id=?, phone=?, address=?, emergency_contact=? WHERE id=?");
                $stmt->execute([$first_name, $last_name, $birth_date, $age, $parent_id ?: null, $phone, $address, $emergency_contact, $_GET['id']]);
                $message = "Sporcu bilgileri güncellendi!";
            }
        } catch (Exception $e) {
            $error = "Hata: " . $e->getMessage();
        }
    } else {
        $error = "Ad, soyad ve doğum tarihi zorunludur!";
    }
}

// Sporcu silme işlemi
if ($action === 'delete' && isset($_GET['id'])) {
    try {
        $stmt = $pdo->prepare("UPDATE athletes SET status = 'inactive' WHERE id = ?");
        $stmt->execute([$_GET['id']]);
        $message = "Sporcu pasif hale getirildi!";
    } catch (Exception $e) {
        $error = "Hata: " . $e->getMessage();
    }
}

// Veli listesi (dropdown için)
$parents = $pdo->query("SELECT id, full_name FROM users WHERE user_type = 'veli' ORDER BY full_name")->fetchAll();

// Sporcu listesi
$athletes = $pdo->query("
    SELECT a.*, u.full_name as parent_name 
    FROM athletes a 
    LEFT JOIN users u ON a.parent_id = u.id 
    WHERE a.status = 'active' 
    ORDER BY a.first_name, a.last_name
")->fetchAll();

// Düzenleme için sporcu bilgileri
$edit_athlete = null;
if ($action === 'edit' && isset($_GET['id'])) {
    $stmt = $pdo->prepare("SELECT * FROM athletes WHERE id = ?");
    $stmt->execute([$_GET['id']]);
    $edit_athlete = $stmt->fetch();
}
?>

<div class="page-header">
    <div class="page-title">
        <i class="fas fa-users"></i>
        <h2>Sporcu Yönetimi</h2>
    </div>
    <a href="?action=add" class="btn btn-primary">
        <i class="fas fa-user-plus"></i>
        <span>Yeni Sporcu Ekle</span>
    </a>
</div>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>

<?php if ($error): ?>
    <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<?php if ($action === 'add' || $action === 'edit'): ?>
    <div class="form-container">
        <h3>
            <i class="fas fa-<?php echo $action === 'add' ? 'user-plus' : 'user-edit'; ?>"></i>
            <?php echo $action === 'add' ? 'Yeni Sporcu Ekle' : 'Sporcu Düzenle'; ?>
        </h3>
        
        <form method="post" action="">
            <div class="form-row">
                <div class="form-group">
                    <label>Ad *</label>
                    <input type="text" name="first_name" value="<?php echo htmlspecialchars($edit_athlete['first_name'] ?? ''); ?>" required>
                </div>
                <div class="form-group">
                    <label>Soyad *</label>
                    <input type="text" name="last_name" value="<?php echo htmlspecialchars($edit_athlete['last_name'] ?? ''); ?>" required>
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-group">
                    <label>Doğum Tarihi *</label>
                    <input type="date" name="birth_date" value="<?php echo $edit_athlete['birth_date'] ?? ''; ?>" required>
                </div>
                <div class="form-group">
                    <label>Veli</label>
                    <select name="parent_id">
                        <option value="">Veli Seçin</option>
                        <?php foreach ($parents as $parent): ?>
                            <option value="<?php echo $parent['id']; ?>" <?php echo ($edit_athlete['parent_id'] ?? '') == $parent['id'] ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($parent['full_name']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-group">
                    <label>Telefon</label>
                    <input type="text" name="phone" value="<?php echo htmlspecialchars($edit_athlete['phone'] ?? ''); ?>">
                </div>
                <div class="form-group">
                    <label>Acil Durum İletişim</label>
                    <input type="text" name="emergency_contact" value="<?php echo htmlspecialchars($edit_athlete['emergency_contact'] ?? ''); ?>">
                </div>
            </div>
            
            <div class="form-group">
                <label>Adres</label>
                <textarea name="address" rows="3"><?php echo htmlspecialchars($edit_athlete['address'] ?? ''); ?></textarea>
            </div>
            
            <div class="form-actions">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-<?php echo $action === 'add' ? 'plus' : 'save'; ?>"></i>
                    <span><?php echo $action === 'add' ? 'Ekle' : 'Güncelle'; ?></span>
                </button>
                <a href="?" class="btn btn-secondary">
                    <i class="fas fa-times"></i>
                    <span>İptal</span>
                </a>
            </div>
        </form>
    </div>
<?php else: ?>
    <div class="table-container">
        <table class="data-table">
            <thead>
                <tr>
                    <th>Ad Soyad</th>
                    <th>Yaş</th>
                    <th>Veli</th>
                    <th>Telefon</th>
                    <th>Kayıt Tarihi</th>
                    <th>İşlemler</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($athletes as $athlete): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($athlete['first_name'] . ' ' . $athlete['last_name']); ?></td>
                        <td><?php echo $athlete['age']; ?></td>
                        <td><?php echo htmlspecialchars($athlete['parent_name'] ?? 'Atanmamış'); ?></td>
                        <td><?php echo htmlspecialchars($athlete['phone'] ?? '-'); ?></td>
                        <td><?php echo date('d.m.Y', strtotime($athlete['registration_date'])); ?></td>
                        <td>
                            <a href="?action=edit&id=<?php echo $athlete['id']; ?>" class="btn btn-sm btn-secondary">
                                <i class="fas fa-edit"></i>
                                <span>Düzenle</span>
                            </a>
                            <a href="?action=delete&id=<?php echo $athlete['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Emin misiniz?')">
                                <i class="fas fa-trash"></i>
                                <span>Sil</span>
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
<?php endif; ?>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>