<?php
$page_title = 'API Ayarları - BAŞKENT 1910 GÜCÜ SK';
require_once __DIR__ . '/../includes/header.php';

$action = $_GET['action'] ?? 'list';
$message = '';
$error = '';

// API ayarlarını güncelleme
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $firebase_key = trim($_POST['firebase_server_key'] ?? '');
    $jwt_secret = trim($_POST['jwt_secret'] ?? '');
    $api_url = trim($_POST['api_base_url'] ?? '');
    $notification_enabled = isset($_POST['notification_enabled']) ? '1' : '0';
    $app_version = trim($_POST['app_version'] ?? '');
    
    try {
        // Firebase Server Key güncelle
        $stmt = $pdo->prepare("UPDATE api_settings SET setting_value = ? WHERE setting_key = 'firebase_server_key'");
        $stmt->execute([$firebase_key]);
        
        // JWT Secret güncelle
        $stmt = $pdo->prepare("UPDATE api_settings SET setting_value = ? WHERE setting_key = 'jwt_secret'");
        $stmt->execute([$jwt_secret]);
        
        // API Base URL güncelle
        $stmt = $pdo->prepare("UPDATE api_settings SET setting_value = ? WHERE setting_key = 'api_base_url'");
        $stmt->execute([$api_url]);
        
        // Notification enabled güncelle
        $stmt = $pdo->prepare("UPDATE api_settings SET setting_value = ? WHERE setting_key = 'notification_enabled'");
        $stmt->execute([$notification_enabled]);
        
        // App version güncelle
        $stmt = $pdo->prepare("UPDATE api_settings SET setting_value = ? WHERE setting_key = 'app_version'");
        $stmt->execute([$app_version]);
        
        $message = "API ayarları başarıyla güncellendi!";
    } catch (Exception $e) {
        $error = "Hata: " . $e->getMessage();
    }
}

// Mevcut API ayarlarını getir
$settings = [];
$stmt = $pdo->query("SELECT setting_key, setting_value, description FROM api_settings ORDER BY setting_key");
while ($row = $stmt->fetch()) {
    $settings[$row['setting_key']] = [
        'value' => $row['setting_value'],
        'description' => $row['description']
    ];
}

// API test fonksiyonu
if ($action === 'test' && isset($_GET['endpoint'])) {
    $endpoint = $_GET['endpoint'];
    $api_url = $settings['api_base_url']['value'];
    
    // Test endpoint'ini çağır
    $test_url = $api_url . '/' . $endpoint;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $test_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($http_code == 200) {
        $message = "API endpoint başarıyla test edildi! (HTTP $http_code)";
    } else {
        $error = "API endpoint testi başarısız! (HTTP $http_code)";
    }
}
?>

<div class="page-header">
    <div class="page-title">
        <i class="fas fa-cogs"></i>
        <h2>API Ayarları</h2>
    </div>
    <div class="api-status">
        <span class="status-indicator <?php echo !empty($settings['firebase_server_key']['value']) ? 'active' : 'inactive'; ?>">
            <i class="fas fa-circle"></i>
            <?php echo !empty($settings['firebase_server_key']['value']) ? 'API Aktif' : 'API Pasif'; ?>
        </span>
    </div>
</div>

<?php if ($message): ?>
    <div class="alert alert-success">
        <i class="fas fa-check-circle"></i>
        <?php echo htmlspecialchars($message); ?>
    </div>
<?php endif; ?>

<?php if ($error): ?>
    <div class="alert alert-error">
        <i class="fas fa-exclamation-circle"></i>
        <?php echo htmlspecialchars($error); ?>
    </div>
<?php endif; ?>

<div class="form-container">
    <h3>
        <i class="fas fa-key"></i>
        API Konfigürasyonu
    </h3>
    
    <form method="post" action="">
        <div class="form-row">
            <div class="form-group">
                <label>Firebase Server Key *</label>
                <input type="text" name="firebase_server_key" 
                       value="<?php echo htmlspecialchars($settings['firebase_server_key']['value'] ?? ''); ?>" 
                       placeholder="AAAA...">
                <small class="form-help">Firebase Console'dan alınan Server Key</small>
            </div>
            <div class="form-group">
                <label>JWT Secret Key *</label>
                <input type="text" name="jwt_secret" 
                       value="<?php echo htmlspecialchars($settings['jwt_secret']['value'] ?? ''); ?>" 
                       placeholder="Güçlü bir gizli anahtar girin">
                <small class="form-help">Token şifreleme için kullanılır</small>
            </div>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label>API Base URL *</label>
                <input type="url" name="api_base_url" 
                       value="<?php echo htmlspecialchars($settings['api_base_url']['value'] ?? ''); ?>" 
                       placeholder="http://localhost/1910/api">
                <small class="form-help">Android uygulamasının bağlanacağı API adresi</small>
            </div>
            <div class="form-group">
                <label>Uygulama Versiyonu</label>
                <input type="text" name="app_version" 
                       value="<?php echo htmlspecialchars($settings['app_version']['value'] ?? ''); ?>" 
                       placeholder="1.0.0">
                <small class="form-help">Android uygulama versiyonu</small>
            </div>
        </div>
        
        <div class="form-group">
            <label class="checkbox-label">
                <input type="checkbox" name="notification_enabled" 
                       <?php echo ($settings['notification_enabled']['value'] ?? '0') == '1' ? 'checked' : ''; ?>>
                <span>Push Notification Sistemi Aktif</span>
            </label>
            <small class="form-help">Velilere bildirim gönderme özelliğini etkinleştirir</small>
        </div>
        
        <div class="form-actions">
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save"></i>
                <span>Ayarları Kaydet</span>
            </button>
            <a href="?action=test&endpoint=health" class="btn btn-secondary">
                <i class="fas fa-play"></i>
                <span>API Test Et</span>
            </a>
        </div>
    </form>
</div>

<div class="api-info-grid">
    <div class="info-card">
        <div class="info-icon">
            <i class="fas fa-mobile-alt"></i>
        </div>
        <div class="info-content">
            <h4>Android Uygulaması</h4>
            <p>API ayarları Android uygulamasının çalışması için gereklidir.</p>
        </div>
    </div>
    
    <div class="info-card">
        <div class="info-icon">
            <i class="fas fa-bell"></i>
        </div>
        <div class="info-content">
            <h4>Push Notifications</h4>
            <p>Firebase Server Key ile velilere bildirim gönderebilirsiniz.</p>
        </div>
    </div>
    
    <div class="info-card">
        <div class="info-icon">
            <i class="fas fa-shield-alt"></i>
        </div>
        <div class="info-content">
            <h4>Güvenlik</h4>
            <p>JWT Secret Key ile güvenli kullanıcı girişi sağlanır.</p>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
