<?php
$page_title = 'Dashboard - BAŞKENT 1910 GÜCÜ SK';
require_once __DIR__ . '/includes/header.php';

// İstatistikler
$stats = [];

// Toplam sporcu sayısı
$stmt = $pdo->query("SELECT COUNT(*) as total FROM athletes WHERE status = 'active'");
$stats['athletes'] = $stmt->fetch()['total'];

// Toplam veli sayısı
$stmt = $pdo->query("SELECT COUNT(*) as total FROM users WHERE user_type = 'veli'");
$stats['parents'] = $stmt->fetch()['total'];

// Bu ay ödenen aidat sayısı
$stmt = $pdo->query("SELECT COUNT(*) as total FROM payments WHERE payment_month = DATE_FORMAT(NOW(), '%Y-%m') AND status = 'paid'");
$stats['payments_this_month'] = $stmt->fetch()['total'];

// Bu ay yoklama sayısı
$stmt = $pdo->query("SELECT COUNT(*) as total FROM attendance WHERE year = YEAR(NOW()) AND month = MONTH(NOW())");
$stats['attendance_this_month'] = $stmt->fetch()['total'];

// Uygulama istatistikleri
$stmt = $pdo->query("SELECT COUNT(*) as total FROM notifications WHERE sent_at IS NOT NULL");
$stats['notifications_sent'] = $stmt->fetch()['total'];

$stmt = $pdo->query("SELECT COUNT(*) as total FROM training_schedules");
$stats['training_schedules'] = $stmt->fetch()['total'];

$stmt = $pdo->query("SELECT COUNT(*) as total FROM payments WHERE status = 'overdue'");
$stats['overdue_payments'] = $stmt->fetch()['total'];

$stmt = $pdo->query("SELECT COUNT(*) as total FROM attendance WHERE training_date = CURDATE() AND status = 'present'");
$stats['today_present'] = $stmt->fetch()['total'];

// Aylık trend verileri
$monthly_stats = [];
for ($i = 5; $i >= 0; $i--) {
    $month = date('Y-m', strtotime("-$i month"));
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM payments WHERE payment_month = '$month' AND status = 'paid'");
    $monthly_stats[] = [
        'month' => date('M Y', strtotime("-$i month")),
        'payments' => $stmt->fetch()['total']
    ];
}

// Yaş grupları
$age_groups = $pdo->query("
    SELECT 
        CASE 
            WHEN age < 10 THEN '6-9 Yaş'
            WHEN age < 14 THEN '10-13 Yaş'
            WHEN age < 18 THEN '14-17 Yaş'
            ELSE '18+ Yaş'
        END as age_group,
        COUNT(*) as count
    FROM athletes 
    WHERE status = 'active' 
    GROUP BY age_group 
    ORDER BY MIN(age)
")->fetchAll();
?>

<div class="dashboard">
    <h2>Dashboard</h2>
    
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-users"></i>
            </div>
            <div class="stat-content">
                <h3>Aktif Sporcular</h3>
                <div class="stat-number"><?php echo $stats['athletes']; ?></div>
                <div class="stat-subtitle">Toplam kayıtlı sporcu</div>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-user-friends"></i>
            </div>
            <div class="stat-content">
                <h3>Toplam Veli</h3>
                <div class="stat-number"><?php echo $stats['parents']; ?></div>
                <div class="stat-subtitle">Uygulama kullanıcısı</div>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-credit-card"></i>
            </div>
            <div class="stat-content">
                <h3>Bu Ay Ödenen Aidat</h3>
                <div class="stat-number"><?php echo $stats['payments_this_month']; ?></div>
                <div class="stat-subtitle">Aylık ödeme sayısı</div>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-clipboard-check"></i>
            </div>
            <div class="stat-content">
                <h3>Bu Ay Yoklama</h3>
                <div class="stat-number"><?php echo $stats['attendance_this_month']; ?></div>
                <div class="stat-subtitle">Aylık yoklama kaydı</div>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-bell"></i>
            </div>
            <div class="stat-content">
                <h3>Gönderilen Bildirim</h3>
                <div class="stat-number"><?php echo $stats['notifications_sent']; ?></div>
                <div class="stat-subtitle">Toplam bildirim sayısı</div>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-dumbbell"></i>
            </div>
            <div class="stat-content">
                <h3>Antrenman Programı</h3>
                <div class="stat-number"><?php echo $stats['training_schedules']; ?></div>
                <div class="stat-subtitle">Aktif program sayısı</div>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-exclamation-triangle"></i>
            </div>
            <div class="stat-content">
                <h3>Geciken Aidat</h3>
                <div class="stat-number"><?php echo $stats['overdue_payments']; ?></div>
                <div class="stat-subtitle">Ödenmemiş aidat</div>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-calendar-check"></i>
            </div>
            <div class="stat-content">
                <h3>Bugün Gelen</h3>
                <div class="stat-number"><?php echo $stats['today_present']; ?></div>
                <div class="stat-subtitle">Bugünkü antrenmana gelen</div>
            </div>
        </div>
    </div>
    
    <!-- Grafik ve Analiz Bölümü -->
    <div class="analytics-section">
        <div class="analytics-grid">
            <!-- Aylık Aidat Trendi -->
            <div class="chart-container">
                <div class="chart-header">
                    <h3><i class="fas fa-chart-line"></i> Aylık Aidat Trendi</h3>
                    <span class="chart-subtitle">Son 6 ay ödeme verileri</span>
                </div>
                <div class="chart-content">
                    <div class="trend-chart">
                        <?php foreach ($monthly_stats as $index => $month_data): ?>
                            <div class="trend-bar">
                                <div class="bar" style="height: <?php echo max(20, ($month_data['payments'] / max(1, max(array_column($monthly_stats, 'payments')))) * 100); ?>%"></div>
                                <div class="bar-label"><?php echo $month_data['month']; ?></div>
                                <div class="bar-value"><?php echo $month_data['payments']; ?></div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
            
            <!-- Yaş Grupları Dağılımı -->
            <div class="chart-container">
                <div class="chart-header">
                    <h3><i class="fas fa-chart-pie"></i> Yaş Grupları Dağılımı</h3>
                    <span class="chart-subtitle">Sporcu yaş dağılımı</span>
                </div>
                <div class="chart-content">
                    <div class="age-groups">
                        <?php foreach ($age_groups as $age_group): ?>
                            <div class="age-group-item">
                                <div class="age-group-info">
                                    <span class="age-group-name"><?php echo $age_group['age_group']; ?></span>
                                    <span class="age-group-count"><?php echo $age_group['count']; ?> sporcu</span>
                                </div>
                                <div class="age-group-bar">
                                    <div class="age-group-progress" style="width: <?php echo ($age_group['count'] / max(1, $stats['athletes'])) * 100; ?>%"></div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Uygulama Durumu -->
    <div class="app-status-section">
        <div class="status-grid">
            <div class="status-card">
                <div class="status-icon">
                    <i class="fas fa-mobile-alt"></i>
                </div>
                <div class="status-content">
                    <h4>Android Uygulaması</h4>
                    <p>Veliler mobil uygulamadan sporcu bilgilerini takip edebilir</p>
                    <div class="status-badge active">Aktif</div>
                </div>
            </div>
            
            <div class="status-card">
                <div class="status-icon">
                    <i class="fas fa-bell"></i>
                </div>
                <div class="status-content">
                    <h4>Push Notifications</h4>
                    <p>Anlık bildirimlerle velileri bilgilendirin</p>
                    <div class="status-badge active">Aktif</div>
                </div>
            </div>
            
            <div class="status-card">
                <div class="status-icon">
                    <i class="fas fa-shield-alt"></i>
                </div>
                <div class="status-content">
                    <h4>Güvenlik</h4>
                    <p>JWT token ile güvenli kullanıcı girişi</p>
                    <div class="status-badge active">Aktif</div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="quick-actions">
        <h3><i class="fas fa-bolt"></i> Hızlı İşlemler</h3>
        <div class="action-buttons">
            <a href="/admin/pages/athletes.php?action=add" class="btn btn-primary">
                <i class="fas fa-user-plus"></i>
                <span>Yeni Sporcu Ekle</span>
            </a>
            <a href="/admin/pages/attendance.php" class="btn btn-secondary">
                <i class="fas fa-clipboard-check"></i>
                <span>Yoklama Al</span>
            </a>
            <a href="/admin/pages/payments.php" class="btn btn-success">
                <i class="fas fa-credit-card"></i>
                <span>Aidat İşlemi</span>
            </a>
            <a href="/admin/pages/push_notifications.php" class="btn btn-warning">
                <i class="fas fa-bell"></i>
                <span>Bildirim Gönder</span>
            </a>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>