<?php
require_once __DIR__ . '/../../config/database.php';  // ../../ ile 2 seviye yukarı çık
require_once __DIR__ . '/session.php';
require_login();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title ?? 'BAŞKENT 1910 GÜCÜ SK - Admin'; ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="/admin/css/style.css?v=<?php echo time(); ?>">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <div class="admin-container">
        <header class="admin-header">
            <div class="header-left">
                <div class="logo">
                    <i class="fas fa-futbol"></i>
                    <h1>BAŞKENT 1910 GÜCÜ SK</h1>
                </div>
                <span class="subtitle">Yönetim Paneli</span>
            </div>
            <div class="user-info">
                <div class="user-welcome">
                    <i class="fas fa-user-circle"></i>
                    <span>Hoş geldiniz, <strong><?php echo htmlspecialchars($_SESSION['admin_name']); ?></strong></span>
                </div>
                <a href="/admin/logout.php" class="logout-btn">
                    <i class="fas fa-sign-out-alt"></i>
                    Çıkış
                </a>
            </div>
        </header>
        
               <nav class="admin-nav">
            <a href="/admin/index.php" class="nav-item">
                <i class="fas fa-tachometer-alt"></i>
                <span>Dashboard</span>
            </a>
            <a href="/admin/pages/athletes.php" class="nav-item">
                <i class="fas fa-users"></i>
                <span>Sporcular</span>
            </a>
            <a href="/admin/pages/parents.php" class="nav-item">
                <i class="fas fa-user-friends"></i>
                <span>Veliler</span>
            </a>
            <a href="/admin/pages/trainings.php" class="nav-item" title="Antrenman Programları">
                <i class="fas fa-dumbbell"></i>
                <span>Antrenman</span>
            </a>
            <a href="/admin/pages/payments.php" class="nav-item" title="Aidat Yönetimi">
                <i class="fas fa-credit-card"></i>
                <span>Aidatlar</span>
            </a>
            <a href="/admin/pages/attendance.php" class="nav-item" title="Yoklama Yönetimi">
                <i class="fas fa-clipboard-check"></i>
                <span>Yoklama</span>
            </a>
            <a href="/admin/pages/notifications.php" class="nav-item" title="Bildirim Yönetimi">
                <i class="fas fa-bell"></i>
                <span>Bildirim</span>
            </a>
            <a href="/admin/pages/api_settings.php" class="nav-item" title="API Ayarları">
                <i class="fas fa-cogs"></i>
                <span>API</span>
            </a>
            <a href="/admin/pages/push_notifications.php" class="nav-item" title="Push Notifications">
                <i class="fas fa-mobile-alt"></i>
                <span>Push</span>
            </a>
            <a href="/admin/pages/user_management.php" class="nav-item" title="Veli Şifre Yönetimi">
                <i class="fas fa-user-shield"></i>
                <span>Şifreler</span>
            </a>
            <a href="/admin/pages/data_export.php" class="nav-item" title="Veri Dışa Aktarma">
                <i class="fas fa-download"></i>
                <span>Export</span>
            </a>
            <a href="/admin/pages/cash_register.php" class="nav-item" title="Kasa Yönetimi">
                <i class="fas fa-cash-register"></i>
                <span>Kasa</span>
            </a>
            <a href="/admin/pages/reports.php" class="nav-item" title="Raporlar ve Analiz">
                <i class="fas fa-chart-bar"></i>
                <span>Raporlar</span>
            </a>
            <a href="/admin/pages/backup.php" class="nav-item" title="Yedekleme Sistemi">
                <i class="fas fa-database"></i>
                <span>Yedekleme</span>
            </a>
            <a href="/admin/pages/system_settings.php" class="nav-item" title="Sistem Ayarları">
                <i class="fas fa-cogs"></i>
                <span>Ayarlar</span>
            </a>
            <a href="/admin/pages/simple_email.php" class="nav-item" title="Email Sistemi">
                <i class="fas fa-envelope"></i>
                <span>Email</span>
            </a>
            <a href="/admin/pages/lesson_notes.php" class="nav-item" title="Ders Notları">
                <i class="fas fa-book"></i>
                <span>Ders Notları</span>
            </a>
        </nav>
        
        <main class="admin-main">
            
            